from lacmus2.web import views


def setup_routes(app, csrf):
    app.add_url_rule('/', view_func=views.list_dashboards,
                     defaults={'username': None},
                     methods=['GET', 'POST'])
    app.add_url_rule('/<username>', view_func=views.list_dashboards,
                     methods=['GET', 'POST'])
    app.add_url_rule('/delete-dashboard/<path:name>',
                     view_func=views.delete_dashboard, methods=['POST'])
    app.add_url_rule('/<username>/<path:name>', view_func=views.get_dashboard,
                     methods=['GET', 'POST'])

    app.add_url_rule('/list-hosts/<key>', view_func=views.list_hosts)
