var lacmus = {};

lacmus.barplotColors = [
  ["#7c0c58", "white"], ["#7d0c6b", "white"], ["#7c0c7e", "white"], ["#690c7f", "white"],
  ["#560c7f", "white"], ["#420c80", "white"], ["#2e0b81", "white"], ["#1a0b81", "white"],
  ["#0b1182", "white"], ["#0b2683", "white"], ["#0b3a84", "white"], ["#0a5084", "white"],
  ["#0a6585", "white"], ["#0a7b86", "white"], ["#0a867c", "white"], ["#098767", "white"],
  ["#098851", "white"], ["#09893b", "white"], ["#098925", "white"], ["#098a0f", "white"],
  ["#188b08", "white"], ["#2f8b08", "white"], ["#468c08", "white"], ["#5d8d08", "white"],
  ["#748e07", "white"], ["#8c8e07", "white"], ["#8f7907", "white"], ["#906207", "white"],
  ["#904b06", "white"], ["#913306", "white"], ["#921b06", "white"], ["#920608", "white"],

  ["#f27ccb", "black"], ["#f37be0", "black"], ["#f17bf3", "black"], ["#dc7af3", "black"],
  ["#c87af4", "black"], ["#b37af4", "black"], ["#9d79f4", "black"], ["#8879f4", "black"],
  ["#797ff5", "black"], ["#7894f5", "black"], ["#78a9f5", "black"], ["#77bff5", "black"],
  ["#77d5f6", "black"], ["#77ebf6", "black"], ["#76f6eb", "black"], ["#76f6d5", "black"],
  ["#75f7bf", "black"], ["#75f7a9", "black"], ["#75f792", "black"], ["#74f77b", "black"],
  ["#84f874", "black"], ["#9af873", "black"], ["#b1f873", "black"], ["#c8f873", "black"],
  ["#dff972", "black"], ["#f6f972", "black"], ["#f9e472", "black"], ["#f9cd71", "black"],
  ["#fab671", "black"], ["#fa9e70", "black"], ["#fa8670", "black"], ["#fa7072", "black"],
];

lacmus.missingColors = ["lightgray", "black"];


lacmus.crc16_ccit = function(data) {
  // poly: 0x1021
  var crc = 0xffff;
  for (i = 0; i < data.length; i ++) {
    crc ^= data.charCodeAt(i) << 8;
    for (var b = 0; b < 8; b ++) {
      crc = (crc & 0x8000 ? (crc << 1) ^ 0x1021 : crc << 1) & 0xffff;
    }
  }
  return crc;
}

lacmus.loadChartData = function(container, data) {
  container = $(container);
  var chartkey = container.get(0).id;
  container.removeClass('loading empty no-data fail');
  var items = [];
  var sum = 0;
  if (data['value'] === null) {
    container.addClass('no-data');
    return;
  }
  var graph = container.data('graph');
  $.each(data['value'], function(key, val) {
    items.push([key, val]);
    sum += val;
    if (graph)
      graph.receivePoints(key, [{'x': data['time'], 'y': val}]);
  });
  if (graph) {
    Rickshaw.Series.zeroFill(graph.series);
    graph.update();
  }

  if (sum == 0) {
    container.addClass('empty');
    return;
  }
  items.sort();
  var chart = container.find('ul.chart').empty();
  var legend = container.find('ul.legend').empty();
  $.each(items, function(idx, items) {
    var sigval = items[0];
    var numhosts = items[1];
    if (numhosts == 0)
      return;
    var color;
    if (sigval)
      color = lacmus.barplotColors[lacmus.crc16_ccit(sigval)
                                   % lacmus.barplotColors.length];
    else
      color = lacmus.missingColors;
    var fgbg = {'background-color': color[0], 'color': color[1]};
    var href = "/list-hosts/" + encodeURIComponent(chartkey) +
               "?value=" + encodeURIComponent(sigval);
    chart.append(
      $('<li/>', {css: fgbg, title: (sigval ? sigval : "(missing)") + ": " + numhosts})
        .css({'width': (numhosts / sum * 100) + '%'})
        .append($('<a/>', {text: (sigval ? sigval : "(missing)"), "href": href}))
    );
    legend.append(
      $('<li/>')
        .append($('<span/>', {'class': 'key', css: fgbg,
                              text: (sigval ? sigval : "(missing)")}))
        .append($('<a/>', {'class': 'value', text: numhosts, "href": href}))
    );
  });
}

lacmus.chartDataFail = function(container) {
  $(container).removeClass('loading empty no-data').addClass('fail');
}

lacmus.refreshChart = function(container, apiUri, refreshEvery) {
  var chartkey = container.get(0).id;
  $.getJSON(apiUri + "/v1/chart/" + chartkey, function(data) {
    lacmus.loadChartData(container, data);
  })
  .fail(function() {
    lacmus.chartDataFail(container);
  })
  .always(function() {
    if (refreshEvery) {
      setTimeout(function() {
        lacmus.refreshChart(container, apiUri, refreshEvery)
      }, refreshEvery);
    }
  });
}

lacmus.HISTORICAL_MAX_POINTS = 2880;

lacmus.destroyHistoricalData = function(container) {
  container = $(container);
  container.find('.historical-inner').empty();
  container.find('.historical .slider').empty();
  container.data('graph', null);
}

lacmus.loadHistoricalData = function(container, apiUri, refreshEvery) {
  var chartkey = container.get(0).id;
  var series = [];
  var seriesByName = {};

  function receivePoints(key, data) {
    if (!data)
      return;
    var displayName = key || '(missing)';
    var serie = seriesByName[key];
    if (! serie) {
      var color;
      if (key)
        color = lacmus.barplotColors[lacmus.crc16_ccit(key) % lacmus.barplotColors.length][0];
      else
        color = lacmus.missingColors[0];
      serie = {
        'name': displayName,
        'color': color,
        'data': data
      }
      seriesByName[key] = serie;
      series.push(serie);
    } else {
      $.each(data, function(didx, point) {
        serie['data'].push(point);
      });
    }
    if (serie['data'].length > lacmus.HISTORICAL_MAX_POINTS) {
      serie['data'].splice(0, serie['data'].length - lacmus.HISTORICAL_MAX_POINTS);
    }
  }

  var uri = apiUri + "/v1/historical/" + chartkey;
  $.getJSON(uri)
  .done(function(data) {
    $.each(data['series'], function(idx, serie) {
      receivePoints(serie['name'], serie['data']);
    });
    Rickshaw.Series.zeroFill(series);
    var graph = new Rickshaw.Graph({
      element: container.find('.historical-inner').get(0),
      renderer: 'area',
      interpolation: 'step-after',
      preserve: true,
      stroke: true,
      series: series,
    });
    new Rickshaw.Graph.Axis.Time({
      graph: graph,
      ticksTreatment: 'glow',
      timeFixture: new Rickshaw.Fixtures.Time.Local()
    });
    new Rickshaw.Graph.HoverDetail({
      graph: graph,
      xFormatter: function(x) { return new Date(x * 1000).toString() },
      yFormatter: function(y) { return y ? y.toString() : ''; }
    });
    new Rickshaw.Graph.RangeSlider({
      graph: graph,
      element: container.find('.historical .slider').get(0),
    });
    container.data('graph', graph);
    graph.receivePoints = receivePoints;
    graph.render();
  });
}


lacmus.barplot = function(containers, apiUri, refreshEvery) {
  $(containers).each(function(idx, container) {
    lacmus.refreshChart($(container), apiUri, refreshEvery);
    $(container).find('.historical')
    .on('show.bs.collapse', function() {
      lacmus.loadHistoricalData($(container), apiUri, refreshEvery);
      $(container).find('#' + $(container).get(0).id + '-legend').collapse('show');
    })
    .on('hidden.bs.collapse', function() {
      $(container).find('.historical-inner').empty();
    });
  });
};

lacmus.listHosts = function(chartkey, value, page, apiUri) {
  $('#error-loading').hide();
  $('#loading-content').show();
  var urlparams = "?value=" + encodeURIComponent(value)
                  + "&page=" + encodeURIComponent(page);
  $.getJSON(apiUri + "/v1/hosts/" + encodeURIComponent(chartkey)
            + urlparams, function(data) {
    lacmus.loadChartData('div.barplot', data);

    $('#signal').text(data['source']['signal']);
    if (data['source']['selector']) {
      $('#selector').text(data['source']['selector']);
    } else {
      $('#selector').parents('.selector').hide();
    }
    if (data['source']['filters'].length) {
      $('#filters').show();
      $('#filterslist').empty();
      $.each(data['source']['filters'], function(idx, pair) {
        var key = pair[0];
        var value = pair[1];
        $('#filterslist')
          .append($('<code/>', {'text': key}))
          .append("=")
          .append($('<samp/>', {'text': value}));
        if (idx != data['source']['filters'].length - 1) {
          $('#filterslist').append(', ');
        }
      });
    } else {
      $('#filters').hide();
    }
    if (data['hosts'].length) {
      $('#no-hosts').hide();
      $('#hostlist').show().attr('start', 1 + data['hosts_on_page'] * data['page']);
      $('#hostlist').empty();
      $('#hostlist-title').show();
      $.each(data['hosts'], function(idx, host) {
        var hosturi = 'https://oops.yandex-team.ru/?q=' + encodeURIComponent(host);
        $('#hostlist')
          .append($('<li/>')
            .append($('<a/>', {'text': host, 'href': hosturi})));
      });
      $('nav.pager').show();
      if (data['page'] >= data['numpages'] - 1) {
        $('.pager .next-page').hide();
      } else {
        $('.pager .next-page').show();
      }
      if (data['page'] == 0) {
        $('.pager .prev-page').hide();
      } else {
        $('.pager .prev-page').show();
      }
      if ((data['page'] < data['numpages'] - 1) && (data['page'] > 0)) {
        $('.pager .pager-delimiter').show();
      } else {
        $('.pager .pager-delimiter').hide();
      }
    } else {
      $('#hostlist-title').hide();
      $('#hostlist').hide();
      $('nav.pager').hide();
      $('#no-hosts').show();
    }

    $('#loaded-content').show();

    $('div.barplot').find('li').each(function() {
      if ((value == '' && $(this).text() == '(missing)') || $(this).text() == value) {
        $(this).data('toggle', 'tooltip')
          .tooltip({'trigger': 'manual'})
          .tooltip('show');
        return false;
      }
    });
  })
  .always(function() {
    $('#loading-content').hide();
  })
  .fail(function() {
    $('#error-loading').show();
    $('#loaded-content').hide();
  });

  var hostlistCompact = $('#hostlist-compact').hide();
  $('#allhosts .notices > p').hide();
  $('#showallhosts').click(function() {
    $('#allhosts .notices > p').hide();
    if (hostlistCompact.is(':visible')) {
      hostlistCompact.slideUp(200);
    } else if (hostlistCompact.is(':empty')) {
      $('#allhosts .notices .loading-notice').show();
      var urlparams = "?value=" + encodeURIComponent(value)
                      + "&compact=1&allhosts=1";
      $.getJSON(apiUri + "/v1/hosts/" + encodeURIComponent(chartkey)
                + urlparams, function(data) {
        if ( ! data['hosts'].length) {
          $('#allhosts .notices .empty-notice').show();
          return;
        }
        console.log(data['hosts'].join(' '));
        hostlistCompact.append($('<p/>', {'text': data['hosts'].join('\n')}));
        setTimeout(function() { hostlistCompact.slideDown(200); }, 0);
      })
      .always(function() {
        $('#allhosts .notices .loading-notice').hide();
      })
      .fail(function() {
        $('#allhosts .notices .error-notice').show();
      });
    } else {
      hostlistCompact.slideDown(200);
    }
  });
};
