import flask
from flask.ext.babel import gettext

from lacmus2.web import forms


def _save_dashboard(form):
    data = form.data
    flask.current_app.mstorage.save_dashboard(
        flask.g.username,
        dashboard_name=data['name'],
        description=data['desc'],
        charts=data['charts']
    )
    flask.flash(gettext('Dashboard "%(name)s" saved', name=data['name']),
                'success')
    return flask.redirect(flask.url_for('get_dashboard', name=data['name'],
                                        username=flask.g.username))


def list_dashboards(username):
    if not username:
        username = flask.g.username
    dbs = flask.current_app.mstorage.list_dashboards(username)
    signals = flask.current_app.rstorage.get_signals()
    new_dashboard_form = forms.make_dashboard_form(signals, None)
    if new_dashboard_form.validate_on_submit():
        return _save_dashboard(new_dashboard_form)
    return flask.render_template('list_dashboards.html',
                                 dbs=dbs, username=username,
                                 signals=signals,
                                 new_dashboard_form=new_dashboard_form)


def get_dashboard(username, name):
    app = flask.current_app
    db = app.mstorage.get_dashboard(username, name)
    if db is None:
        flask.abort(404)
    signals = app.rstorage.get_signals()
    api_uri = app.config['LACMUS2_API_URI']
    edit_form = forms.make_dashboard_form(signals, db)
    if edit_form.validate_on_submit():
        return _save_dashboard(edit_form)
    return flask.render_template('get_dashboard.html', creator=username,
                                 db=db, api_uri=api_uri, edit_form=edit_form)


def delete_dashboard(name):
    res = flask.current_app.mstorage.delete_dashboard(flask.g.username, name)
    if not res:
        flask.abort(404)
    flask.flash(gettext('Dashboard "%(name)s" deleted', name=name), 'success')
    return flask.redirect(flask.url_for('list_dashboards',
                                        username=flask.g.username))


def list_hosts(key):
    value = flask.request.args.get('value')
    page = flask.request.args.get('page', 0, type=int)
    api_uri = flask.current_app.config['LACMUS2_API_URI']
    return flask.render_template(
        'list_hosts.html', chartkey=key, value=value,
        page=page, api_uri=api_uri
    )
