import library.config
import os
import sys
import time

from api.procman import ProcMan


if __name__ == '__main__':
    ns = sys.argv[1]
    skynet_path = sys.argv[2]
    supervisor_path = sys.argv[3]
    procman = ProcMan()

    svcconfig = library.config.query('skynet.services.lacmus', 'config')

    cfgdir = os.path.join(supervisor_path, 'var', 'lacmus')
    if not os.path.exists(cfgdir):
        os.mkdir(cfgdir, 0o755)

    api_config_files = []
    api_config_values = [
        ('MONGODB_URI', svcconfig['api']['mongo']),
        ('REDIS', svcconfig['api']['redis']),
        ('ACCESS_CONTROL_ALLOW_ORIGIN',
            svcconfig['api']['access_control_allow_origin']),
    ] + list(svcconfig['api'].get('extra', {}).items())
    api_common = '\n\n'.join('%s = %r' % (key, value)
                             for key, value in api_config_values)
    addresses = svcconfig['api']['wsgi_listen_addresses']
    for i, listen_address in enumerate(addresses):
        filename = os.path.join(cfgdir, 'lacmus_api_%d.cfg' % (i, ))
        if isinstance(listen_address, list):
            listen_address = tuple(listen_address)
        elif isinstance(listen_address, basestring):
            listen_address = os.path.join(supervisor_path, listen_address)
        with open(filename, 'w') as f:
            f.write('# generated automatically based on genisys\n'
                    '# section skynet.services.lacmus\n')
            f.write(api_common)
            f.write('\n\nWSGI_LISTEN_ADDRESS = %r\n' % (listen_address, ))
        api_config_files.append(filename)

    ui_config_files = []
    ui_config_values = [
        ('MONGODB_URI', svcconfig['ui']['mongo']),
        ('REDIS', svcconfig['ui']['redis']),
        ('LACMUS2_API_URI', svcconfig['ui']['api_uri'])
    ] + list(svcconfig['ui'].get('extra', {}).items())
    ui_common = '\n\n'.join('%s = %r' % (key, value)
                            for key, value in ui_config_values)
    addresses = svcconfig['ui']['wsgi_listen_addresses']
    for i, listen_address in enumerate(addresses):
        filename = os.path.join(cfgdir, 'lacmus_ui_%d.cfg' % (i, ))
        if isinstance(listen_address, list):
            listen_address = tuple(listen_address)
        elif isinstance(listen_address, basestring):
            listen_address = os.path.join(supervisor_path, listen_address)
        with open(filename, 'w') as f:
            f.write('# generated automatically based on genisys\n'
                    '# section skynet.services.lacmus\n')
            f.write(ui_common)
            f.write('\n\nWSGI_LISTEN_ADDRESS = %r\n' % (listen_address, ))
        ui_config_files.append(filename)

    toiler_config_values = [
        ('MONGODB_URI', svcconfig['toiler']['mongo']),
        ('REDIS', svcconfig['toiler']['redis']),
    ] + list(svcconfig['toiler'].get('extra', {}).items())
    toiler_common = '\n\n'.join('%s = %r' % (key, value)
                                for key, value in toiler_config_values)
    toiler_config_file = os.path.join(cfgdir, 'lacmus_toiler.cfg')
    num_toilers = svcconfig['toiler']['num_instances']
    with open(toiler_config_file, 'w') as f:
        f.write('# generated automatically based on genisys\n'
                '# section skynet.services.lacmus\n')
        f.write(toiler_common)

    environ = {}
    exe = os.path.abspath('bin/pystick3.4')

    api_args = (exe, '-B', os.path.abspath('bin/lacmus2-run-wsgi.py'), 'api',
                '--skynet-path', skynet_path)
    api_environs = [dict(environ, LACMUS2_API_CONFIG=cfgfile)
                    for cfgfile in api_config_files]

    ui_args = (exe, '-B', os.path.abspath('bin/lacmus2-run-wsgi.py'), 'ui',
               '--skynet-path', skynet_path)
    ui_environs = [dict(environ, LACMUS2_WEB_CONFIG=cfgfile)
                   for cfgfile in ui_config_files]

    toiler_args = (exe, '-B', os.path.abspath('bin/lacmus2-run-toiler.py'),
                   '--skynet-path', skynet_path)
    toiler_environs = [dict(environ,
                            LACMUS2_TOILER_CONFIG=toiler_config_file)
                       for _ in range(num_toilers)]

    for env in api_environs:
        procman.create(api_args, env=env, afterlife=0,
                       user='skynet',
                       tags=[ns, 'lacmus'],
                       logStderr=True, liner=True)

    for env in ui_environs:
        procman.create(ui_args, env=env, afterlife=0,
                       user='skynet',
                       tags=[ns, 'lacmus'],
                       logStderr=True, liner=True)

    for env in toiler_environs:
        procman.create(toiler_args, env=env, afterlife=0,
                       user='skynet',
                       tags=[ns, 'lacmus'],
                       logStderr=True, liner=True)

    while True:
        time.sleep(3600)
