#!/bin/bash
set -e
sleep $(( $RANDOM % 10 ))
export LC_ALL=ru_RU.UTF-8
export PATH=$PATH:/place/berkanavt/mapreduce/bin
DATE="$1"
DIR="$2"
TYPE="$3"
if [ "$DATE" == "" ]; then
   DATE=$(date +%Y%m%d --date="2 days ago") 
fi

if [ "$DIR" == "" ]; then
    DIR=$(dirname $0)
fi

if [ "$DIR" == "." ]; then
    DIR=$(dirname $0)
fi

if [ "$TYPE" == "" ]; then
    TYPE="unireports"
fi

ID=$(cat $DIR/id)
DIR=$DIR/$TYPE

#echo $DATE

mkdir -p $DIR/$DATE
cd $DIR/$DATE
pwd

if [ "$TYPE" != "$3" ]; then
    flock /var/lock/latency-$ID-$DATE-spy -c "time ../../parse.py $DATE $ID unireports-spylog" >> parse-spy.out 2>> parse-spy.err
fi

export PATH=$PATH:/place/berkanavt/mapreduce/bin
export MR_USER=trencher
export DEF_MR_SERVER=sakura.search.yandex.net
mapreduce-dev-sakura --read trencher_speedindex/$DATE | awk -F '\t' 'NF==4' > speedindex.$DATE.txt
if [ ! -s speedindex.$DATE.txt ]; then
    rm -f speedindex.$DATE.txt
fi

echo Done: $DATE
