
import itertools
import sys
from collections import defaultdict
import hashlib
from bisect import bisect_left


possible_user_agents = ['Firefox','MSIE','Opera','YaBrowser','UCBrowser','Chrome','Safari','Unknown']
possible_oses = ['iPad','iPhone','Android','Windows Phone','Windows','Macintosh','Linux','Unknown']

key_defaults = {    'ajax':['ajax-all',"ajax-query","not-ajax-query"],
                    'turbo':['turbo-all',"turbo-on","turbo-off"],
                    'https':['http-all',"http","https"],
                    'page':['1+',"1","2+"],  
                    'ar_verdict':['EVERYBODY',"NEUTRAL","ENEMY"],
                    'user_agent': ['all_ua'] + 
                        ["%s_%s/%s" % (f[1], f[0], f[1]) for f in itertools.product(possible_user_agents,possible_oses)],
                    'tld': ['tld-all',"com.tr", "com","ru","ua","kz","by"],
                    'dc':['<all>',"<sas>","<msk>","<man>"],
                    'visibility':['visibility-all','visible','hidden','prerender'],
                    'region':['region-all','spb','ekb','nsk','vladik','kiev','minsk','almaty','astana','msk','istanbul','ankara'],
                    'ua_version': None } #keys here will be added later

#will be calculated later
set_defaults = None
keys_in_game = None
all_possible_keys = None

def gen_all_possible_keys(output_keys, fltr):

    #print output_keys, keys_in_game

    all_possible_keys=set()
    keys_in_game_set = set(keys_in_game)

    for ok in output_keys:
        possible_vals = defaultdict(list)

        for k in keys_in_game:
            if k in ok:
                possible_vals[k] = key_defaults[k] 
            else:
                possible_vals[k] = [ key_defaults[k][0] ]

        #print "possible_vals", possible_vals
        valv = [zip([k]*len(v),v) for k,v in possible_vals.iteritems()]
        #print "valv",valv
        prod = [dict(k) for k in itertools.product(*valv)]
        #print "prod",'\n'.join("%s" % k for k in prod)
        prod = [k for k in prod if fltr(**k)]
        #print "prod",'\n'.join("%s" % k for k in prod) 

        possible_vals = [        '\t'.join(dct[k] for k in keys_in_game) for dct in prod]
        #print possible_vals
        all_possible_keys |= set(possible_vals)

    return all_possible_keys

def gen_keys(outfiles, browser_versions):

    global set_defaults
    global keys_in_game
    global all_possible_keys

    key_defaults['ua_version']=['version_all']+browser_versions
    set_defaults = { k:set(v) for (k,v) in key_defaults.iteritems() }

    keynames = []
    for k in outfiles:
        keynames += outfiles[k]['keys']
        #print keynames        
    keys_in_game = sorted(set.union(*[set(l) for l in keynames]))
    #print keys_in_game

    all_possible_keys=set([])

    for k in outfiles:
        p=gen_all_possible_keys(outfiles[k]['keys'],outfiles[k]['fltr'])
        outfiles[k]['possible_keys']=p
        all_possible_keys |= p

    #all_possible_keys=sorted([intern(s) for s in all_possible_keys])
    all_possible_keys=frozenset([intern(s) for s in all_possible_keys])

    h = hashlib.md5('\n'.join(all_possible_keys)).hexdigest()

    print >> sys.stderr, "All possible keys len: %d " % len(all_possible_keys)
    print >> sys.stderr, '\n'.join(sorted(all_possible_keys)), '\n\n'
    print >> sys.stderr, "All possible keys len: %d " % len(all_possible_keys)
    print >> sys.stderr, "Hash is: %s " % h

    return outfiles,key_defaults,all_possible_keys,set_defaults,keys_in_game,h

def init_globals(tpl):

    global key_defaults
    global set_defaults
    global keys_in_game
    global all_possible_keys
    h = None

    (unused,key_defaults,all_possible_keys,set_defaults,keys_in_game,h)=tpl

    #all_possible_keys=sorted([intern(s) for s in all_possible_keys])

def indexes(keys):

    retval = []
    l = len(all_possible_keys)

    for k in keys:
        i = bisect_left(all_possible_keys,k)
        if i != l and all_possible_keys[i]==k:
            retval += [i]

    return retval

def gen_keys_decart(pageno, ar_verdict, user_agent, server, tld, https, turbo, ajax, visibility, version, region):

    result = {}

    if turbo is None:
        result['turbo']=["turbo-all"]
    elif turbo==True:
        result['turbo']=["turbo-all","turbo-on"]
    elif turbo==False:
        result['turbo']=["turbo-all","turbo-off"]
    else:
        assert False, "wtf turbo is '%s'" % turbo

    assert set(result['turbo']) < set_defaults['turbo'], "wtf turbo is %s" % turbo

    if ajax is None:
        result['ajax']=['ajax-all']
    elif ajax==True:
        result['ajax']=['ajax-all',"ajax-query"]
    elif ajax==False:
        result['ajax']=['ajax-all',"not-ajax-query"]
    else:
        assert False, "wtf ajax is '%s'" % ajax

    assert set(result['ajax']) < set_defaults['ajax'], "wtf ajax is %s" % ajax

    if visibility is None:
        result['visibility']=['visibility-all']
    elif visibility=='visible':
        result['visibility']=['visibility-all','visible']
    elif visibility=='prerender':
        result['visibility']=['visibility-all','prerender']
    elif visibility=='hidden':
        result['visibility']=['visibility-all','hidden']
    else:
        assert False, "wtf visibility is is '%s'" % visibility

    assert set(result['visibility']) < set_defaults['visibility'], "wtf visibility is %s" % visibility

    if https is None:
        result['https']=["http-all"]
    elif https==True:
        result['https']=["http-all","https"]
    elif https==False:
        result['https']=["http-all","http"]
    else:
        assert False, "wtf https is '%s'" % https

    assert set(result['https']) < set_defaults['https'], "wtf https is %s" % https

    if pageno is None:
        result['page']=["1+"]
    elif pageno==0:
        result['page']=["1+","1"]
    elif pageno > 0:
        result['page']=["1+","2+"]
    else:
        assert False, "wtf page is '%s'" % pageno

    assert set(result['page']) < set_defaults['page'], "wtf pageno is %s" % pageno


    if ar_verdict is None:
       result['ar_verdict']=["EVERYBODY"]
    elif ar_verdict=="NEUTRAL":
        result['ar_verdict']=["EVERYBODY","NEUTRAL"]
    elif ar_verdict=="ENEMY":
        result['ar_verdict']=["EVERYBODY","ENEMY"]

    assert set(result['ar_verdict']) < set_defaults['ar_verdict'], "wtf ar_verdict is %s" % ar_verdict


    if user_agent is None:
        result['user_agent']=["all_ua"]
    else:
        result['user_agent']=["all_ua",user_agent]

    assert set(result['user_agent']) < set_defaults['user_agent'], "wtf user_agent is %s" % user_agent

    if server is None:
        result['dc']=["<all>"]
    elif server[:3]=="sas":
        result['dc']=["<all>","<sas>"]
    elif server[:3]=="man":
        result['dc']=["<all>","<man>"]
    else:
        result['dc']=["<all>","<msk>"]
    
    assert set(result['dc']) < set_defaults['dc'], "wtf server %s" % server

    result['tld']=["tld-all"]
    if tld is not None and tld in set_defaults['tld']:
        result['tld'] += [ tld ]
    else:
        print >> sys.stderr, "wtf tld is %s" % tld

    if version is not None and version in set_defaults['ua_version']:
        result['ua_version']=['version_all']+[version]
    elif version is not None:
        (ua,ver)=version.split('/')
        result['ua_version']=['version_all']+[ua+"/Other"]
    else:
        result['ua_version']=['version_all']

    if   region==2:
        result['region']=['region-all','spb']
    elif region==54:
        result['region']=['region-all','ekb']
    elif region==65:
        result['region']=['region-all','nsk']
    elif region==75:
        result['region']=['region-all','vladik']
    elif region==143:
        result['region']=['region-all','kiev']
    elif region==157:
        result['region']=['region-all','minsk']
    elif region==162:
        result['region']=['region-all','almaty']
    elif region==163:
        result['region']=['region-all','astana']
    elif region==213:
        result['region']=['region-all','msk']
    elif region==11508:
        result['region']=['region-all','istanbul']
    elif region==11503:
        result['region']=['region-all','ankara']
    else:
        result['region']=['region-all']


    keys = itertools.product(*[result[k] for k in keys_in_game])
    keys = ['\t'.join(k) for k in keys]

    return [k for k in keys if k in all_possible_keys]

    #return indexes(keys)
