require(bit64)
library(googleVis)
library(reshape2)
library(ggplot2)

kpiplot_boundary=function(data)
{
  upper = quantile(data,0.999)
  lower = quantile(data,0.001)
  distance = upper - lower
  #upper = upper + 0.3*distance
  #lower = lower - 0.1*distance
  
  if (distance==0) { distance=1 } #y=const
  sign = 10**as.integer(log10(distance)-1)
  upper = upper - (upper %% sign) + 2*sign
  lower = lower - (lower %% sign) - sign    
  
  foo=list(upper=upper,lower=lower)
  return(foo)
}

kpiplotv = function(datatable, x, value, split, title="", ylab=value, xlab=x, llab=split, gvis=FALSE, upper=NA, lower=NA, x_is_chron=TRUE, y_log_scale=NULL, height=400, width=1200 )
{
  datatable = as.data.table(datatable)
  
  if (is.na(upper) && is.na(lower) && is.null(y_log_scale))
  {
    d = datatable[,value,with=FALSE]
    foo = kpiplot_boundary(unlist(d))
    upper=foo$upper
    lower=foo$lower
  }
  
  if (gvis == FALSE)
  {    
    y=value
    colour=split
    d=length(unique(unlist(datatable[,colour,with=FALSE])))
    if (x_is_chron) {
      times=unlist(datatable[,x,with=FALSE])
      max_t=max(times)
      min_t=min(times)      
    }
    colors = rainbow(d)       
    
    if (colour=='date') {
      datatable[,date := as.character(date)]
    } 
    
    graph_kpi = ggplot(datatable, aes_string(x=x,y=y,colour=colour,group=colour))
    graph_kpi = graph_kpi + geom_line()
    
    if (x_is_chron) {
      if (max_t-min_t <= 1)
      {
        graph_kpi = graph_kpi + scale_x_chron(format="%H:%M")   
      }
      else
      {
        graph_kpi = graph_kpi + scale_x_chron(format="%Y-%m-%d")   
      }      
    }
    
    graph_kpi = graph_kpi + scale_color_manual(values=colors)
    graph_kpi = graph_kpi + labs(colour=llab)
    graph_kpi = graph_kpi + ggtitle(title)
    graph_kpi = graph_kpi + ylab(ylab)
    graph_kpi = graph_kpi + xlab(xlab)  
    if (!is.null(y_log_scale)) 
    { 
      
      if (!is.na(lower) && !is.na(upper)) { 
        graph_kpi = graph_kpi + scale_y_log10(limits=c(lower, upper),breaks=y_log_scale) 
      }
      else {
        graph_kpi = graph_kpi + scale_y_log10(breaks=y_log_scale)   
      }
    }
    else
    {
      if (!is.na(lower) && !is.na(upper)) { graph_kpi = graph_kpi + coord_cartesian(ylim=c(lower, upper)) } 
    }
    
    return(graph_kpi)
  }
  else
  {
    val = value
    x1 = x
    formula = paste0(x1," ~ ",split)
    
    #debug check - DO NOT UNCOMMENT IN PRODUCTION
    #foo=datatable[,list(.N),by=c("chron","stage","gran","user_agent","tld")]
    #foo=foo[N>2]
    #if (nrow(foo)>0) {
    #  print(foo)  
    #}
    
    casted=dcast(datatable, formula, NULL, value.var = val, fill=NA)
    
    if (x_is_chron)
    {
      if (is.chron(casted[,x1])) {
        casted[,x1]=as.POSIXct(casted[,x1],tz="GMT")  
      }
      else {
        casted[,x1]=as.POSIXct(chron(0,casted[,x1]),tz="GMT")  
      }      
    }
    
    names = names(casted)[2:length(casted)]
    colors = rainbow(length(names))
    colors = lapply(colors,function(s) substr(s,1,7))
    colors = paste(colors,collapse="', '")
    colors = paste0("['",colors,"']")
    
    if (is.null(y_log_scale)) { log_scale='false' }
    else { log_scale='true' }
    
    if (!is.na(lower) && !is.na(upper)) { 
      vAxes=paste0("[{title:'",ylab,"',logScale:",log_scale,",viewWindowMode:'explicit',viewWindow:{ min:",as.character(lower),", max:",as.character(upper),"}, }]")
      hAxes=paste0("[{title:'",xlab,"'}]")
      graphs_kpi_gvis = gvisLineChart(casted, x1, names,options=list(title=title,colors=colors,vAxes=vAxes, hAxes=hAxes,height=height, width=width, lineWidth=1, focusTarget='category'))    #gvis.editor="Edit", 
    }
    else {
      vAxes=paste0("[{title:'",ylab,"',logScale:",log_scale,"}]")
      hAxes=paste0("[{title:'",xlab,"'}]")
      graphs_kpi_gvis = gvisLineChart(casted, x1, names,options=list(title=title,colors=colors,vAxes=vAxes, hAxes=hAxes,height=height, width=width, lineWidth=1, focusTarget='category'))    #gvis.editor="Edit",
    }
    
    return(graphs_kpi_gvis)
  }
}

kpiplot = function(datatable, x, value, split, title=deparse(substitute(datatable)), ylab=deparse(substitute(value)), xlab=deparse(substitute(x)), llab=deparse(substitute(split)), gvis=FALSE, upper=NA, lower=NA, x_is_chron=TRUE, y_log_scale=NULL, height=400, width=1200)
{
  x=deparse(substitute(x))
  value=deparse(substitute(value))
  split=deparse(substitute(split))
  return(kpiplotv(datatable, x, value, split, title, ylab, xlab, llab, gvis, upper, lower, x_is_chron, y_log_scale, height, width))
}

trencher_adapter = function(datatable, values=names(datatable)[sapply(datatable,is.numeric) & (("integer" == sapply(datatable,class)) | ("numeric" == sapply(datatable,class))) ], split)  {
  l=nrow(datatable)
  dt = melt(datatable,measure.vars=values)
  dt=as.data.table(dt)
  setorderv(dt,c("variable",split,"value"),c(1,1,-1))
  count=dt[,.N,keyby=c("variable",split)]
  selection = sapply (count$N, function(N) { scale = N%/%1000+1; return(  0:(N-1) %% scale ==0 ) })
  selection = unlist(selection)
  dt = dt [selection]
  count2=dt[,.N,keyby=c("variable",split)]
  x = sapply (count2$N, function(N) 0:(N-1) )
  x = unlist(x)
  dt [, x := x/10  ]
  return(dt)
}

#dt=data.table(x1=rep(1:6,10),value1=rep(1:6,10), split1=sort(rep(c("a1","a2","a3","a4","a5","a6"),10)))
#foo=kpiplot(datatable=dt, x=x1, value=value1, split=split1, gvis=TRUE)
#foo



