require(bit64)
library(data.table)
library(reshape2)
library(ggplot2)
library(scales)
library(knitr)
library(parallel)
library(chron)

options(scipen=1000000000)
options(mc.cores=8)
options(mc.litecores=8)
Sys.setenv(TZ='GMT')

date = NA

args = commandArgs(trailingOnly = TRUE)
if (length(args) >= 1) {
  date = args[1]
  print(date)
}

if (is.na(date)) {
  date = format(Sys.Date(), "%Y%m%d")
  dir=paste0('unireports/',date)
  dir.create(dir)
  setwd(dir)
}

unireport = readChar('../../unireport.Rmd', file.info('../../unireport.Rmd')$size)

source('../../kpi-plot.R')
source('../../data_load.R')
source('../../new_reports.R')
source('../../render.R')

dojobs = "kpi,uaver,control,timeline,timelineperc,distr,detailed,https"
#detailed,dayoverday.allstage,dayoverday.recent.tld,dayoverday.all
if (length(args) >= 2) {
  dojobs=args[2]
}
dojobs = unlist(strsplit(dojobs,',',fixed=TRUE))
print(dojobs)

data_full = NULL
if (! identical(dojobs, 'tech'))  # TRENCHER-32
{
    #speedindex = speedindex_load(date)
    data_full = data_load(date,type="full",version="uniparse.*")
    #filters
    data_full = data_full[user_agent!='Safari/Windows']
    gc()
}

all_services=c("www","www.touch","www.tablet","images","video","u.morda.all")
www_services=c("www","www.touch","www.tablet")

#This is kpi report with text and funce stuff
jobs_kpi = list()
if ('kpi' %in% dojobs)
{
  filter=list(service=all_services,stage=c("<latency>","ttfb","ttlb","ttfp","bytes_sent"),gran="1d",user_agent=c("all_ua","Chrome/Windows"),ajax="ajax-all")
  kpi = kpi_gen(global_data=data_full, template=NULL, report_name="kpi",value="p95", x="date",filter=filter, graph_split="stage",color_split="tld",page_split=c("service","gran"))
  data1=kpi$data
  rm(kpi)
  
  filter=list(service=all_services,stage=c("ttfp","ttfb","ttlb","content_len","bytes_sent"),gran="1d")
  yabr_kpi = kpi_gen(global_data=data_full, template=NULL, report_name="kpi",value="p95", x="date",filter=filter, graph_split="stage",color_split="user_agent",page_split=c("service","tld","gran"))
  yabr_data1 = yabr_kpi$data
  rm(yabr_kpi)

  filter=list(service=all_services,stage=c("<latency>","ttfb","ttlb","ttfp","bytes_sent"),gran="1d",user_agent=c("all_ua","Chrome/Windows"),ajax=c("ajax-query","not-ajax-query"))
  ajax_data = kpi_gen(global_data=data_full, template=NULL, report_name="kpi",value="p95", x="date",filter=filter, graph_split="stage",color_split="tld",page_split=c("service","gran"))
  ajax_data = ajax_data$data
  ajax_data[ajax=="ajax-query",ajax:="ajax"]
  ajax_data[ajax=="not-ajax-query",ajax:=""]
  
  kpi_report(data1,yabr_data1,ajax_data,FALSE)
  kpi_report(data1,yabr_data1,ajax_data,TRUE)
  rm(data1)
  rm(yabr_data1)
}

kpi_simple=function(value)
{
  stages=c("<latency>","ttfb","ttlb","bytes_sent")

  filter=list(service=www_services,stage=stages,gran="1d",user_agent=c("all_ua","Chrome/Windows"),ajax="ajax-all")
  kpi = kpi_gen(global_data=data_full, template=NULL, report_name="kpi",value=value, x="date", filter=filter, 
                graph_split="stage", color_split="tld", page_split=c("service","gran"))
  data1=kpi$data
  rm(kpi)
 
  filter=list(service=www_services,stage=stages,gran="1d",user_agent=c("all_ua","Chrome/Windows"),ajax=c("ajax-query","not-ajax-query"))
  ajax_data = kpi_gen(global_data=data_full, template=NULL, report_name="kpi",value=value, x="date", filter=filter, 
                      graph_split="stage", color_split="tld", page_split=c("service","gran"))
  ajax_data = ajax_data$data
  ajax_data[ajax=="ajax-query",ajax:="ajax"]
  ajax_data[ajax=="not-ajax-query",ajax:=""]
 
  kpi_report_simple(data1,ajax_data,FALSE,value)
  kpi_report_simple(data1,ajax_data,TRUE,value)
  rm(data1)
  rm(ajax_data)
}

if ('kpi_simple' %in% dojobs)
{
  kpi_simple("p95")
}

if ('kpi_simple_50' %in% dojobs)
{
  kpi_simple("p50")
}

#make very detailed service-stage page for whole timeline, each day its own line 
if ("dayoverday.all" %in% dojobs) {
  filter=list(service=all_services,gran="1hr")
  jobs_month_stage1 = kpi_gen(global_data=data_full, path='dayoverday', report_name="weeksplit", value="p95", filter=filter, graph_split="week",color_split="ymdf",page_split=c("service","stage","gran"))
  render_snow(jobs_month_stage1,gvis=FALSE)
  render_snow(jobs_month_stage1,gvis=TRUE)
  
  jobs_month_stage2 = kpi_gen(global_data=data_full, path='dayoverday', report_name="weekdaysplit", value="p95", filter=filter, graph_split="weekday",color_split="ymdf",page_split=c("service","stage","gran"))  
  render_snow(jobs_month_stage2,gvis=FALSE)
  render_snow(jobs_month_stage2,gvis=TRUE)
}

#make very detailed service-stage page for whole timeline
#same as before but not day over day just single line

#removed as no user agent info in FULL now

if ("timeline" %in% dojobs) {
  filter=list(service=all_services,gran="1d")
  tld_long = kpi_gen(global_data=data_full, path='timeline', report_name="tld",value="p95", x="date",filter=filter, graph_split="stage",color_split="tld",page_split=c("service","gran"))
  render_snow(tld_long,gvis=FALSE)
  render_snow(tld_long,gvis=TRUE)
  
  filter=list(service=all_services,gran="1d",tld=c("ru","com.tr"))
  ua_long = kpi_gen(global_data=data_full, path='timeline', report_name="ua",value="p90", x="date",filter=filter, graph_split="stage",color_split="user_agent",page_split=c("service","tld","gran"))
  render_snow(ua_long,gvis=FALSE)
  render_snow(ua_long,gvis=TRUE)    
}

if ("timelineperc" %in% dojobs) {
  for (p in c("p25","p50","p75","p80","p90","p95"))
  {
    filter=list(service=www_services,gran="1d")
    tld_long = kpi_gen(global_data=data_full, path='timeline', report_name=paste0(p,".","tld"),value=p, x="date",filter=filter, graph_split="stage",color_split="tld",page_split=c("service","gran"))
    render_snow(tld_long,gvis=FALSE)
    render_snow(tld_long,gvis=TRUE)
    
    filter=list(service=www_services,gran="1d",tld=c("ru","com.tr"))
    ua_long = kpi_gen(global_data=data_full, path='timeline', report_name=paste0(p,".","ua"),value=p, x="date",filter=filter, graph_split="stage",color_split="user_agent",page_split=c("service","tld","gran"))
    render_snow(ua_long,gvis=FALSE)
    render_snow(ua_long,gvis=TRUE)      
  }
  
}

#make report with just number of queries to control loss of data
if ('control' %in% dojobs)
{
  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date = as.chron(current_date,0)
  
  all_dates=unique(data_full$date)
  all_dates = all_dates[all_dates>current_date-30 & all_dates<=current_date ]
  
  filter = list(service=all_services, stage=c("<latency>","ttfb","ttfp"), gran="1hr", user_agent=c("all_ua"), date=all_dates)
  control = kpi_gen(global_data=data_full, path='control', template=unireport, report_name="querynum",value="len", x="chron",filter=filter, graph_split="stage",color_split="service",page_split=c("tld","ajax","gran"))
  control2 = kpi_gen(global_data=data_full, path='control', template=unireport, report_name="querynum",value="len", x="chron",filter=filter, graph_split="service",color_split="stage",page_split=c("tld","ajax","gran"))
  #fields = names(control$data)
  #fields = fields[fields!='time' & fields!="len"]
  #control$data = control$data[,list(N=.N,len=sum(len)),by=fields]
  render_snow(control,gvis=TRUE)
  render_snow(control,gvis=FALSE)
  render_snow(control2,gvis=TRUE)
  render_snow(control2,gvis=FALSE)
  rm(control)
}

#day over day graphs splitted by tld for last seven days
if ("dayoverday.recent.tld" %in% dojobs) {
  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date = as.chron(current_date,0)
  
  grans=c("1hr")
  stages=c("<latency>","ttfp_total","ttfb_total","html_total","ttfb","html","dns","tcp_handhake")
  
  all_dates=unique(data_full$date)
  all_dates = all_dates[all_dates>current_date-7 & all_dates<=current_date ]
  filter=list(service=all_services,gran=grans,date=all_dates,stage=stages)
  tld_day1=kpi_gen(global_data=data_full, path='dayoverday', report_name="tld.week", value="p95", filter=filter, graph_split="ymdf",color_split="tld",page_split=c("service","stage","gran"))
  render_snow(tld_day1,gvis=FALSE)
  render_snow(tld_day1,gvis=TRUE)
  
  current_wday = weekdays(current_date)
  filter=list(service=all_services,gran=grans,weekday=current_wday,stage=stages)
  tld_day2=kpi_gen(global_data=data_full, path='dayoverday', report_name="tld.weekday", value="p95", filter=filter, graph_split="ymdf",color_split="tld",page_split=c("service","stage","gran"))
  render_snow(tld_day2,gvis=FALSE)
  render_snow(tld_day2,gvis=TRUE)
  
}

#make very detailed service-stage page for whole timeline
if ("dayoverday.allstage" %in% dojobs) {
  
  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date = as.chron(current_date,0)
  
  all_dates=unique(data_full$date)
  all_dates = all_dates[all_dates>current_date-14 & all_dates<=current_date ]  
  
  filter=list(service=all_services,gran="1hr",date=all_dates)
  tld_intraday = kpi_gen(global_data=data_full, path='dayoverday', report_name="dayoverday.allstage.1page", x="time",value="p95", filter=filter, graph_split="stage",color_split="ymdf",page_split=c("service","gran"))
  #setkeyv(tld_intraday$data,c("service","stage","date","time"))
  render_snow(tld_intraday,gvis=FALSE)
  render_snow(tld_intraday,gvis=TRUE)
}

if ('distr' %in% dojobs)
{
  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date = as.chron(current_date,0)
  
  all_dates=unique(data_full$date)
  all_dates = all_dates[all_dates>current_date-21 & all_dates<=current_date ]  
  
  filter=list(service=www_services,stage=c("<latency>","ttfb","ttlb","ttfp","html"),gran="1hr",date=all_dates)
  distr = kpi_gen(global_data=data_full, path='distr', template=unireport, report_name="distr",value="value", x="p",filter=filter, graph_split="time",color_split="date",page_split=c("stage","service","user_agent","tld","gran"))
  
  render_snow(distr,gvis=FALSE)
  render_snow(distr,gvis=TRUE)
}

rm(data_full) # no longer need it
gc()

if ("https" %in% dojobs) {
  
  data_https = data_load(date,type="https",version="uniparse.*rp.*",remove_trash=TRUE)
  gc()
  
  stages = c('<latency>','bytes_sent','content_len','dns','html','html_total','tcp_handshake','ttfb','ttfb_total','ttfp','ttfp_total','ttlb','ttlb_total','ttlb_ex_after_print','ttlb_ex_before_print','after_ya_search','after_priv_template')
  
  filter=list(service=all_services,gran="1d",stage=stages)
  tld_long = kpi_gen(global_data=data_https, path='timeline', report_name="https_cmp",value="p95", x="date",filter=filter, graph_split="stage",color_split="https",page_split=c("service","region"))
  render_snow(tld_long,gvis=FALSE)
  render_snow(tld_long,gvis=TRUE)
  
  filter=list(service=all_services,gran="1d",stage=stages)
  tld_long = kpi_gen(global_data=data_https, path='timeline', report_name="https_cmp",value="p95", x="date",filter=filter, graph_split="stage",color_split="https",page_split=c("service","user_agent"))
  render_snow(tld_long,gvis=FALSE)
  render_snow(tld_long,gvis=TRUE)
  
  if ("timeline" %in% dojobs) {    
    filter=list(service=all_services,gran="1d",tld=c("tld-all"),stage=stages)
    ua_long = kpi_gen(global_data=data_https, path='timeline', report_name="region",value="p90", x="date",filter=filter, graph_split="stage",color_split="region",page_split=c("service"))
    render_snow(ua_long,gvis=FALSE)
    render_snow(ua_long,gvis=TRUE)        
  }  
  
  if ("timelineperc" %in% dojobs) {
    
    filter=list(service=all_services,gran="1d",tld=c("tld-all"),stage=stages)
    ua_long = kpi_gen(global_data=data_https, path='timeline', report_name="region",value="value", x="date",filter=filter, graph_split="pp",color_split="region",page_split=c("service","stage"))
    render_snow(ua_long,gvis=FALSE)
    render_snow(ua_long,gvis=TRUE)   
  }
  
  
  if ('control' %in% dojobs) {
    filter=list(service=all_services,gran="1d",stage="ttfb")
    tld_long = kpi_gen(global_data=data_https, path='control', report_name="https_cmp",value="len", x="date",filter=filter, graph_split="service",color_split="https",page_split=c("region"))
    render_snow(tld_long,gvis=FALSE)
    render_snow(tld_long,gvis=TRUE)
    
    filter=list(service=all_services,gran="1d",stage="ttfb")
    tld_long = kpi_gen(global_data=data_https, path='control', report_name="https_cmp",value="len", x="date",filter=filter, graph_split="service",color_split="https",page_split=c("user_agent"))
    render_snow(tld_long,gvis=FALSE)
    render_snow(tld_long,gvis=TRUE)  
    
    filter=list(service=all_services,gran="1d",tld="tld-all",stage="ttfb")
    regcontrol = kpi_gen(global_data=data_https, path='control', report_name="region",value="len", x="date",filter=filter, graph_split="service",color_split="region",page_split="gran")
    render_snow(regcontrol,gvis=FALSE)
    render_snow(regcontrol,gvis=TRUE)    
    
  }
  
  if ("detailed" %in% dojobs) {
    
    current_date = as.POSIXct(date, format = "%Y%m%d")
    current_date = as.chron(current_date,0)
    
    all_dates=unique(data_https$date)
    all_dates = all_dates[all_dates>current_date-7 & all_dates<=current_date ]  
    
    filter=list(service=all_services,gran=c("1hr","10m"),tld=c("tld-all"),stage=stages, date=all_dates)
    ua_long = kpi_gen(global_data=data_https, path='detailed', report_name="https_region",value="p90", x="time",filter=filter, graph_split="stage",color_split="date",page_split=c("service","region","gran"))
    render_snow(ua_long,gvis=FALSE)
    render_snow(ua_long,gvis=TRUE)        
    
    filter=list(service=all_services,gran=c("1hr","10m"),tld=c("tld-all"),stage=stages, date=all_dates)
    ua_long = kpi_gen(global_data=data_https, path='detailed', report_name="https_useragent",value="p90", x="time",filter=filter, graph_split="stage",color_split="date",page_split=c("service","user_agent","gran"))
    render_snow(ua_long,gvis=FALSE)
    render_snow(ua_long,gvis=TRUE)        
    
  }
  
  rm(data_https)
  gc()
}



if ("uaver" %in% dojobs) {
  
  data_ver = data_load(date,type="vers",version="uniparse.*rp.*")
  gc()
    
  grans=c("1d")
  stages=c("<latency>","ttfp_total","ttfb_total","html_total","ttfb","ttfp","ttlb","ttlb_total","html","dns","tcp_handhake")
  user_agents=unique(data_ver$user_agent)
  user_agents=user_agents[user_agents != "all_ua"]
  
  filter=list(service=all_services,gran=grans,stage=stages,ua_version="version_all")
  ua_day1=kpi_gen(global_data=data_ver, path='useragents', x="date", report_name="ua", value="p90", filter=filter, graph_split="stage",color_split="user_agent",page_split=c("service","tld","gran"))
  render_snow(ua_day1,gvis=FALSE)
  render_snow(ua_day1,gvis=TRUE)
  
  filter=list(service=all_services,gran=grans,stage=stages,tld="ru",user_agent=user_agents)
  ua_day1=kpi_gen(global_data=data_ver, path='useragents', x="date", report_name="ua_ver", value="p90", filter=filter, graph_split="stage",color_split="ua_version",page_split=c("service","tld","gran"))
  ua_day1$data=ua_day1$data[ua_version != 'version_all',]
  render_snow(ua_day1,gvis=FALSE)
  render_snow(ua_day1,gvis=TRUE)

  filter=list(service=all_services,gran=grans,stage=stages,tld="ru",user_agent=user_agents)
  ua_day1=kpi_gen(global_data=data_ver, path='useragents', x="date", report_name="ua_ver.count", value="len", filter=filter, graph_split="stage",color_split="ua_version",page_split=c("service","tld","gran"))
  ua_day1$data=ua_day1$data[ua_version != 'version_all',]
  render_snow(ua_day1,gvis=FALSE)
  render_snow(ua_day1,gvis=TRUE)
    
  rm(data_ver)
}

data_raw = NULL

if ("detailed" %in% dojobs) {

  data_raw = data_load(date,version="uniparse.*rp.*",remove_trash=TRUE)
  gc()
  
  filter=list(service=all_services,gran="1d",https=c("http","https"))
  tld_long = kpi_gen(global_data=data_raw, path='detailed', report_name="timeline.allstages.tld",value="p95", x="date",filter=filter, graph_split="stage",color_split="tld",page_split=c("service","https","gran"))
  render_snow(tld_long,gvis=FALSE)
  render_snow(tld_long,gvis=TRUE)

  percs = NULL
  if ("detailedperc" %in% dojobs) {
    percs = c("p25","p50","p75","p90","p95")
  }
  else {
    percs = c("p95")
  }
  
  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date = as.chron(current_date,0)
  all_dates=unique(data_raw$date)
  all_dates = all_dates[all_dates>current_date-7 & all_dates<=current_date ]
  filter=list(service=all_services,gran=c("1hr","10m"),date=all_dates)
  for (m in percs) {
    tld_long = kpi_gen(global_data=data_raw, path='detailed', report_name=paste0("7days.allstages.tld.",m),value=m, x="chron",filter=filter, graph_split="stage",color_split="tld",page_split=c("service","https","gran"))
    render_snow(tld_long,gvis=FALSE)
    render_snow(tld_long,gvis=TRUE)
  }

  all_dates=unique(data_raw$date)
  all_dates = all_dates[all_dates>current_date-7 & all_dates<=current_date ]
  filter=list(service=all_services,gran=c("1hr","10m"),date=all_dates)
  jobs_day1=kpi_gen(global_data=data_raw, path="detailed",report_name="recentdays", value="p95", filter=filter, graph_split="stage",color_split="ymdf",page_split=c("service","https","gran","tld"))
  render_snow(jobs_day1,gvis=FALSE)
  render_snow(jobs_day1,gvis=TRUE)
  
  current_wday = weekdays(current_date)
  filter=list(service=all_services,gran=c("1hr","10m"),weekday=current_wday)
  jobs_day2=kpi_gen(global_data=data_raw, path="detailed", report_name="sameweekdays", value="p95", filter=filter, graph_split="stage",color_split="ymdf",page_split=c("service","https","gran","tld"))
  render_snow(jobs_day2,gvis=FALSE)
  render_snow(jobs_day2,gvis=TRUE) 
  
  rm(data_raw)
  
}

if ("spy" %in% dojobs) {
  data_spy = data_load(date,type="spy",version="uniparse.*s.*",remove_trash=FALSE)
  gc()
    
  filter=list(service=c("google","yandex","google/#","google/search","yandex/yandsearch"),gran=c("1d"),https=c("http","https"))
  spy=kpi_gen(global_data=data_spy, path="spylog/percentiles",report_name="spylog", x="date", value="value", filter=filter, graph_split="pp",color_split="service_https",page_split=c("tld","stage"))
  spy$data=spy$data[len>=3000]
  render_snow(spy,gvis=FALSE)
  render_snow(spy,gvis=TRUE)    
  
  #current_date = as.POSIXct(date, format = "%Y%m%d")
  #current_date = as.chron(current_date,0)  
  #all_dates=unique(data_spy$date)
  #all_dates = all_dates[all_dates>current_date-7 & all_dates<=current_date ]  
  #filter=list(service=c("google","yandex","google/#","google/search","yandex/yandsearch"),gran="1hr",date=all_dates,time=c(0.25,0.5,0.75),https=c("http","https"))
  #distr = kpi_gen(global_data=data_spy, path='spylog/distr', template=unireport, report_name="distr",value="value", x="p",filter=filter, graph_split="stage",color_split="service_https",page_split=c("date","time","tld","gran"))
  #render_snow(distr,gvis=FALSE)
  #render_snow(distr,gvis=TRUE)

  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date = as.chron(current_date,0)  
  all_dates=unique(data_spy$date)
  all_dates = all_dates[all_dates>current_date-14 & all_dates<=current_date ]  
  filter=list(service=c("google","yandex","google/#","google/search","yandex/yandsearch"),gran="1d",date=all_dates,https=c("http","https"))
  distr = kpi_gen(global_data=data_spy, path='spylog/distr', template=unireport, report_name="day-distr",value="value", x="p",filter=filter, graph_split="stage",color_split="service_https",page_split=c("date","tld","gran"))
  distr$data=distr$data[len>=3000]  
  render_snow(distr,gvis=FALSE)
  render_snow(distr,gvis=TRUE)
  
  
  all_dates=unique(data_spy$date)
  filter=list(service=c("google","yandex","google/#","google/search","yandex/yandsearch"),https=c("http","https"),gran="1d")
  for (m in c("p25","p50","p75","p90","p95")) {
    spy=kpi_gen(global_data=data_spy, path="spylog/stages_day_agg", report_name=paste0("spylog.dayagg.",m), x="date", value=m, filter=filter, graph_split="stage",color_split="service_https",page_split=c("tld"))
    spy$data=spy$data[len>=1000]
    render_snow(spy,gvis=FALSE)
    render_snow(spy,gvis=TRUE)    
  }  
  
  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date = as.chron(current_date,0)  
  all_dates=unique(data_spy$date)
  all_dates = all_dates[all_dates>current_date-10 & all_dates<=current_date ]  
  filter=list(service=c("google","yandex","google/#","google/search","yandex/yandsearch"),gran=c("1hr"),https=c("http","https"),date=all_dates)
  for (m in c("p25","p50","p75","p90","p95")) {
    spy=kpi_gen(global_data=data_spy, path="spylog/stages",report_name=paste0("spylog.",m), x="chron", value=m, filter=filter, graph_split="stage",color_split="service_https",page_split=c("tld"))
    spy$data=spy$data[len>=50]
    render_snow(spy,gvis=FALSE)
    render_snow(spy,gvis=TRUE)    
  }  
  
  
}



if ("tech" %in% dojobs) {
  current_date = as.POSIXct(date, format = "%Y%m%d")
  current_date=as.chron(current_date,0)
  from = format(current_date-75, "%Y%m%d")

  data_tech = data_load(date,type="tech",version="uniparse.*rp.*",remove_trash=FALSE, lower_date=from)
  data_tech = data_tech[datasource=="profile_redir"]
  gc()
  
  all_dates=unique(data_tech$date)
  all_dates = all_dates[all_dates>current_date-10 & all_dates<=current_date ]  
  filter=list(service=www_services, date=all_dates)
  for (m in c("p50","p95")) {
    tech=kpi_gen(global_data=data_tech, path="tech",report_name=paste0("data_centers.",m), x="chron", value=m, filter=filter, graph_split="stage",color_split="dc",page_split=c("service","tld","gran"))
    render_snow(tech,gvis=FALSE)
    render_snow(tech,gvis=TRUE)    
    
    tech=kpi_gen(global_data=data_tech, path="tech",report_name=paste0("data_centers.",m), x="chron", value=m, filter=filter, graph_split="stage",color_split="dc",page_split=c("service","region","gran"))
    render_snow(tech,gvis=FALSE)
    render_snow(tech,gvis=TRUE)    
  }
  
  filter=list(service=www_services, stage="<latency>",date=all_dates,tld="tld-all")
  tech=kpi_gen(global_data=data_tech, path="tech",report_name="querynum.region", x="chron", value="len", filter=filter, graph_split="region",color_split="dc",page_split=c("service","tld","gran"))
  render_snow(tech,gvis=FALSE)
  render_snow(tech,gvis=TRUE)    
  
  filter=list(service=www_services, stage="<latency>",date=all_dates)
  tech=kpi_gen(global_data=data_tech, path="tech",report_name="querynum.tld", x="chron", value="len", filter=filter, graph_split="tld",color_split="dc",page_split=c("service","gran"))
  render_snow(tech,gvis=FALSE)
  render_snow(tech,gvis=TRUE)    
  
  
  filter=list(service=www_services,date=current_date,gran="10m")
  for (m in c("p50","p95")) {
    tech=kpi_gen(global_data=data_tech, path="tech",report_name=paste0("data_centers.1day.",m), x="chron", value=m, filter=filter, graph_split="stage",color_split="dc",page_split=c("service","tld","gran"))
    render_snow(tech,gvis=FALSE)
    render_snow(tech,gvis=TRUE)    
    
    tech=kpi_gen(global_data=data_tech, path="tech",report_name=paste0("data_centers.1day.",m), x="chron", value=m, filter=filter, graph_split="stage",color_split="dc",page_split=c("service","region","gran"))
    render_snow(tech,gvis=FALSE)
    render_snow(tech,gvis=TRUE)    
  }
  
  filter=list(service=www_services,stage="<latency>",date=current_date,tld="tld-all",gran="10m")
  tech=kpi_gen(global_data=data_tech, path="tech",report_name="querynum.region.1day", x="chron", value="len", filter=filter, graph_split="region",color_split="dc",page_split=c("service","tld","gran"))
  render_snow(tech,gvis=FALSE)
  render_snow(tech,gvis=TRUE)    
  
  filter=list(service=www_services,stage="<latency>",date=current_date,gran="10m")
  tech=kpi_gen(global_data=data_tech, path="tech",report_name="querynum.tld.1day", x="chron", value="len", filter=filter, graph_split="tld",color_split="dc",page_split=c("service","gran"))
  render_snow(tech,gvis=FALSE)
  render_snow(tech,gvis=TRUE)    
  
}


