import array
import gc
import resource
from mapreducelib import MapReduce, Record


def reduce_flush(outformats, key, subkey, values, gran):

    l = len(values)
    if l==0: return

    dimensions = '\t'.join(key.split('\t')[3:])
    assert subkey is not None, "wtf subkey is None"

    (date,time)=subkey.split("\t")    

    values = sorted(values)
    auc = 0

    for i in range(0,100):
        pos = l*i/100
        auc += values[pos]

    index=0
    for fmt in sorted(outformats.keys()):
        if gran in outformats[fmt]['gran'] and dimensions in outformats[fmt]['possible_keys']:
            percs = outformats[fmt]['perc']
            sampled = []
            for i in percs:
                pos = l*i/100
                sampled += [ str(values[pos]) ]
            sampled = [ str(l), str(auc) ] + sampled        
            yield Record(date,key+"\t"+subkey+"\t" + gran,'\t'.join(sampled),tableIndex=index)
        index+=1

def reduce_operation(tpl, key, recs):
    
    outformats = tpl[0]

    grans = set([])

    for f in outformats.itervalues():
        grans |= f['gran']

    #WARNING: modify according to key = "%s\t%s\t%s\t" % (record['type'], service, stage)
    
    s1m_on = '1m' in grans
    s10m_on = '10m' in grans
    s1hr_on = '1hr' in grans
    s1d_on = '1d' in grans

    values1m=array.array('i')
    values10m=array.array('i')
    values1hr=array.array('i')
    values1d=array.array('i')

    current_subkey_1m=None
    current_subkey_10m=None
    current_subkey_1hr=None
    current_subkey_1d=None

    for j in recs:


        values = array.array('i')
        for i in j.value.split(" "):
            values.append(int(i))

        if s1m_on:

            subkey1m = j.subkey

            if current_subkey_1m != subkey1m:
                for r in reduce_flush(outformats,key,current_subkey_1m,values1m,"1m"):
                    yield r
                values1m = array.array('i')
                current_subkey_1m = subkey1m

            values1m += values


        if s10m_on:  

            subkey10m = j.subkey[:-1]+"0"

            if current_subkey_10m != subkey10m:
                for r in reduce_flush(outformats,key,current_subkey_10m,values10m,"10m"):
                    yield r
                values10m = array.array('i')
                current_subkey_10m = subkey10m

            values10m += values


        if s1hr_on:  

            subkey1hr = j.subkey[:-2]+"00"

            if current_subkey_1hr != subkey1hr:
                for r in reduce_flush(outformats,key,current_subkey_1hr,values1hr,"1hr"):
                    yield r  
                values1hr = array.array('i')
                current_subkey_1hr = subkey1hr

            values1hr += values

        if s1d_on:  

            subkey1d = j.subkey[:-5]+"00:00"

            if current_subkey_1d != subkey1d:
                for r in reduce_flush(outformats,key,current_subkey_1d,values1d,"1d"):
                    yield r  
                values1hr = array.array('i')
                current_subkey_1d = subkey1d

            values1d += values

    for r in reduce_flush(outformats,key,current_subkey_1m,values1m,"1m"):
        yield r
    for r in reduce_flush(outformats,key,current_subkey_10m,values10m,"10m"):
        yield r
    for r in reduce_flush(outformats,key,current_subkey_1hr,values1hr,"1hr"):
        yield r 
    for r in reduce_flush(outformats,key,current_subkey_1d,values1d,"1d"):
        yield r 

    values1m = None
    values10m = None
    values1hr = None
    values1d = None
    gc.collect()

