require(bit64)
library(data.table)
library(reshape2)
library(ggplot2)
library(scales)
library(knitr)
library(parallel)
library(chron)
library(markdown)

make_report=function(data, report_name, path='.', template, value, x="time", color_split, graph_split, page_split, gvis)
{
  #print(paste(nrow(data),report_name, template="unireport.Rmd", value, x="time", color_split, graph_split, page_split, gvis, collapse=' '))
  #print(paste(page_split,nrow(data)))
    
  dir = path
  suffix=''
  if (gvis) gvisstr="gVis" else gvisstr="ggplot"
  
  if (!is.null(page_split)) {
    #print(page_split)
    data=data_list_filter(data,page_split)
    if (nrow(data)==0) {
      print(paste("No data for filter page_split:",page_split))
      return(NULL)
    }

    #print(paste(page_split,nrow(data)))
    
    suffix = paste0(unlist(page_split),collapse='.')
    suffix = gsub("/", "-", suffix)
    if ('service' %in% names(page_split)) {
      dir=paste0(dir,'/',page_split[['service']])
    }
  }
  dir.create(dir, showWarnings = FALSE, recursive=TRUE)
  dir=normalizePath(dir)
  
  output=paste(report_name,suffix,gvisstr,sep='.')
  output=paste0(dir,'/',output,".html")
  blocks = make_blocks(data=data, report_name=report_name, path=path, template=template, value=value, x=x, color_split=color_split, graph_split=graph_split, page_split=page_split, gvis=gvis)
  #print("Before knit")
  html = NULL
  withCallingHandlers({
    out = knit(text=template, encoding = 'UTF-8', quiet=TRUE)
    html = markdownToHTML(text=out, output=NULL, stylesheet='../../markdown.css')
  }, error=function(e) {
    print(sys.calls())
    print(e)
    stop(e)
  })
  
  if (gvis) {
    for (l in blocks) {
      g = capture.output(plot(l$real_graph,tag='chart'))
      g = paste0(g,collapse='\n')
      html = gsub(l$graph,g,html,fixed=TRUE)
    }
  }

  write(html,file=output)
  print(output) 
  
  #print("After knit")
}

debug(make_report)

kpi_report=function(data1, yabr_data1, yabr_ajax, gvis)
{
  report_name="kpi"
  value="p95"
  x="date"
  services=unique(c(data1$service,yabr_data1$service,yabr_ajax$service))
  
  for (service in services) {
    print(service)
    dir = '.'
    suffix=''
    if (gvis) gvisstr="gVis" else gvisstr="ggplot"
    data=data_list_filter(data1,list(service=service))
    yabr_data=data_list_filter(yabr_data1,list(service=service))
    data_ajax=data_list_filter(yabr_ajax,list(service=service))
    
    stopifnot(nrow(data) > 0 && nrow(yabr_data) > 0)
    suffix = service
    dir=normalizePath(dir)
    output=paste(report_name,suffix,gvisstr,sep='.')
    knit2html(input="../../kpi.Rmd", output=paste0(dir,'/',output,".html"), encoding = 'UTF-8', stylesheet='../../markdown.css',quiet=TRUE)
  }
}

kpi_report_simple=function(data1, ajax_data, gvis, value)
{
  report_name="kpi"
  x="date"
  services=unique(c(data1$service))
  
  for (service in services) {
    print(service)
    dir = '.'
    suffix=''
    if (gvis) gvisstr="gVis" else gvisstr="ggplot"
    data=data_list_filter(data1, list(service=service))
    data_ajax=data_list_filter(ajax_data, list(service=service))

    stopifnot(nrow(data) > 0)
    suffix = service
    dir=normalizePath(dir)
    if (value == 'p95') {
        output=paste(report_name,'simple',suffix,gvisstr,sep='.')
    } else {
        output=paste(report_name,'simple',suffix,value,gvisstr,sep='.')
    }
    knit2html(input="../../kpi_simple.Rmd", output=paste0(dir,'/',output,".html"), encoding = 'UTF-8', stylesheet='../../markdown.css',quiet=TRUE)
  }
}


kpi_gen=function(global_data, report_name, path='.', template=unireport, value, x="time", filter, color_split, graph_split, page_split)  
{
  fnames = names(filter)
  need_fields = unique(c("date","stage","time",x,"gran",value,"len",color_split,graph_split,page_split))
  need_fields = unique(c(need_fields,fnames))
  shared_data = data_prep(global_data, need_fields=need_fields, filter=filter)  
  
  if (nrow(shared_data)==0) {
    return (list(data=shared_data,fn_args=list()))
  }
  
  fn_args=list()
  
  if (is.null(page_split)) {
    ll=list(f=make_report,report_name=report_name,path=path,template=template,value=value,x=x,color_split=color_split,graph_split=graph_split,page_split=NULL)
    fn_args[[length(fn_args)+1]]=ll
  } else {
    cols = unique(shared_data[,page_split,with=FALSE],by=NULL)
    for (N in 1:nrow(cols)) {
      M = as.list(cols[N])
      ll=list(f=make_report,report_name=report_name,path=path,template=template,value=value,x=x,color_split=color_split,graph_split=graph_split,page_split=M)
      fn_args[[length(fn_args)+1]]=ll
    }
  }
  
  return (list(data=shared_data,fn_args=fn_args))
}

kpi_gen_day_agg=function(global_data, report_name, path='.', template=unireport, value, x="time", filter, color_split, graph_split, page_split)  
{
  kpi = kpi_gen(global_data=global_data, report_name=report_name, path=path, template=template, value=value, x=x, filter=filter, color_split=color_split, graph_split=graph_split, page_split=page_split)  
  
  fields = names(kpi$data)
  fields=fields[fields!='time' & fields!=value & fields!="len"]
  data1 = kpi$data[,list(N=.N,len=sum(len),value=round(sum(as.integer64(len)*eval(parse(text=value)))/sum(len))),by=fields]
  ndata1=names(data1)
  ndata1[ndata1=="value"]=value
  setnames(data1,ndata1)
  
  full_dates = unique(data1[service %in% c("www","images","video"), date])
  data1=data1[!(service %in% c("u.www","u.images","u.video")) | !(date %in% full_dates)]
  
  #crazy BUG workaround: remove overwriting service=="www" everything glitches
  #looks like global sting pool glitches on load 
  data1[service=="u.www" | service=="www", service:="www"]
  data1[service=="u.images" | service=="images", service:="images"]
  data1[service=="u.video" | service=="videos", service:="video"]
  
  kpi$data=data1
  return(kpi)
}

make_blocks = function (data, report_name, path, template, value, x, color_split, graph_split, page_split, gvis) {
  
  result = list()
  
  boundary=kpiplot_boundary(unlist(data[,value,with=FALSE]))
  
  f = function(fltr) {
    l=data_list_filter(data,fltr,debug=TRUE)
    local_data=l$data
    if (nrow(local_data)!=0) {
      
      if (x=='p') {
        x_is_chron = FALSE
        log_scale=c(10,33,100,333,1000,3333,10000)
      } else {
        x_is_chron = TRUE  
        log_scale = NULL
      }
      
      graph_kpi = kpiplotv(local_data, x=x, value=value, split=color_split, gvis=gvis, title=as.character(fltr), x_is_chron=x_is_chron, y_log_scale=log_scale)
      t=local_data[,sum(len),by=color_split]
      return (list(graph_kpi=graph_kpi,text=l$expr,count=as.character(t)))    
    } else {
      return(NULL)
    }
  }
  
  cols = unique(data[,graph_split,with=FALSE], by=NULL)
  for (N in 1:nrow(cols)) {
    M=as.list(cols[N])
    g = f(M)
    if (!is.null(g)) {
      if (gvis) {
        result[[length(result)+1]]=list(string=g$count, graph=paste0("<BLOCK_",as.character(length(result)+1),"_PLACEHOLDER_LJHDSKLJDSLJHDLKSJDLKSJDL>"), real_graph=g$graph_kpi)  
      }else {
        result[[length(result)+1]]=list(string=g$count, graph=g$graph_kpi)  
      }
      
    }
  }  
  
  return(result) 
}

