#!/usr/bin/pypy

import gzip
import sys

assert len(sys.argv)>1, "Usage %s [file.gz]" % sys.argv[0]

times = {}
cycles = {}


with gzip.open(sys.argv[1]) as gz:
	for line in gz:
		
		line = line.strip("\n")

		if line[0]=="#":
			continue

		process=line[0:16].strip()
		pid = int(line[16:16+6].strip())
		cpu = int(line[24:24+3].strip())
		secs = int(line[28:28+8].strip())
		msec = int(line[37:37+6].strip())
		time = secs*1000000 + msec
		ip = line[54:54+16].strip()
		fn = line[71:].strip()
		foo=fn.split('(')
		fn = foo[0].strip()
		place= "("+"(".join(foo[1:])

		timediff=0

		if cpu in times: 
			timediff=time-times[cpu]

		times[cpu]=time

		print "\t".join([process,str(pid),str(cpu),str(time),str(timediff),fn,place])

