
import sys
import pickle

from regexps_and_stuff import *

#assigned in global file
allowed_types = None


def parse_yt(value):
    fields = {}
    labels = None
    for pair in value.split('\t'):
        kv = pair.split('=')
        if kv[0] not in ('_stbx', 'timestamp'):
            if kv[0] == 'labels':
                labels = kv[1]
            else:
                fields[kv[0]] = kv[1]
    return labels, "@@".join(('{}={}'.format(k, v) for k, v in fields.iteritems()))


def profile_record_handler(rec, log_type):

    assert not '\0' in rec.value, "binary junk in record"

    line = rec.value
    line = line.strip()
    if line == "": return "empty line"

    stages = []
    gparams = parse_yt(line)
    assert len(gparams) == 2 or len(gparams) == 3, "assert len(gparams) == 2 or len(gparams) == 3"

    stages = gparams[0].split('@@')
    params = gparams[1].split('@@')

    req_stages = {}

    query_type = None
    reqid = None
    req_params = {}

    for s in stages:
        svals = s.split(':')

        if query_type == None:
            query_type = svals[0]
            if query_type=="":
                query_type="<none>"
            elif query_type=="touchsearch":  # TODO: fix in java-report
                query_type="www-touch"
            elif log_type == 1:
                return "record skipped: " + query_type
        else:
            if svals[0][0:6]=="total_":
                reqid = svals[0][6:]
                svals[0]="total"

            assert svals[0] not in req_stages, "double key " + svals[0]

            if query_type != "www-touch":   # TODO: stage times in java-report, GATEWAY-3643
                req_stages[svals[0]] = float(svals[2])*1000

            if svals[0]=="after_print_to_user":
                req_stages["<latency>"] = float(svals[1])*1000

            if svals[0]=="total":
                req_stages["<total>"] = float(svals[1])*1000

    for p in params:
        if '=' in p:
            name, value = p.split('=')
            if name == "reqid":   # for java-report, TRENCHER-4
                reqid = value
        else:
            name = p
            value = None

        req_params[name]=value

    pageno=None

    if 'pageno' in req_params:
        pageno = int(req_params['pageno'])

    content_len=None
    bytes_sent=None

    if 'content_len' in req_params:
        content_len=int(req_params['content_len'])

    if 'bytes_sent' in req_params:
        bytes_sent=int(req_params['bytes_sent'])

    reqid_parts = reqid.split('-') if reqid else []
    reqid_page = [rp for rp in reqid_parts if rp[:1]=='p']
    if len(reqid_page)==1:
        reqid_page=reqid_page[0]
        new_pageno=int(reqid_page[1:])
        assert pageno==None or pageno==new_pageno, "different pageno from param and reqid: " + rec.value
        pageno=new_pageno
    elif len(reqid_page)==0:
        if pageno == None:
            pageno = 0
    else:
        print >> sys.stderr, "WTF strange reqid" + reqid

    server = '-'.join(reqid_parts[2:4])

    tld = req_params.get('tld')
    if tld is None and query_type == 'www-touch':
        tld = 'ru'  # TODO: fix this in java report

    if 'report_time' in req_params:
        req_stages["<report_time>"] = float(req_params['report_time'])*1000

    if 'report_time_' in req_params:
        req_stages["<report_time_>"] = float(req_params['report_time_'])*1000

    if content_len is not None:
        req_stages["content_len"]=content_len

    if bytes_sent is not None:
        req_stages["bytes_sent"]=bytes_sent

    reqid_seconds = reqid[:10]

    limit = 1000000000 #we often got timstamp in this field instead of time diff.
                       #limit it by value by 1M seconds.

    if query_type in allowed_types:

        record=dict()
        record['type']='profile'
        record['reqid']=reqid
        record['ts'] = int(reqid_seconds)
        record['service'] = update_one_service(query_type)
        record['profile_service']=query_type
        assert pageno >= 0, "pageno should be a positive integer, has %s " % pageno
        record['pageno']=pageno
        record['server']=server
        record['tld']=tld

        httpstatus = 0
        if 'httpstatus' in req_params:
            httpstatus=req_params['httpstatus']
            if httpstatus == '0E0':
                httpstatus=599
            httpstatus = int(httpstatus)

        if query_type == 'www-touch':
            if '<latency>' not in req_stages:
                return "!200"   # todo: fix in java-report
        else:
            if httpstatus != 200:
                return "!200"

        #record['httpstatus']=int(httpstatus)

        for (stage,time) in req_stages.iteritems():
            assert int(time) < limit, "%s is too big %d" % (stage,time)
            record['.'+stage]=int(time)

        return record

    else:
        return query_type

