require(bit64)
library(data.table)
library(reshape2)
library(ggplot2)
library(scales)
library(knitr)
library(parallel)

profile_raw = fread("raw_server_www_asearch_data.txt", sep="\t", header=FALSE, verbose=TRUE, stringsAsFactors=TRUE)
setnames(profile_raw,c("server","type","http","date","time","querynum","stage","latency"))
profile_raw$datetime = paste(profile_raw$date,profile_raw$time)
profile_raw$ts = as.POSIXct(profile_raw$datetime, format = "%Y-%m-%d %H:%M")
profile_raw$min = as.POSIXlt(profile_raw$ts)$min
profile_raw$hour = as.POSIXlt(profile_raw$ts)$hour
setkeyv(profile_raw,"latency")
p1 = floor(seq(1:length(profile_raw$latency))/length(profile_raw$latency)*100)
profile_raw[,percentile:=p1]
setkeyv(profile_raw,"time")

#casted = dcast(profile_raw, time ~ percentile, length, value = "latency", fill=NA)
mcasted = profile_raw[percentile>90,.N,by=c("min")]

sorted = sort(profile_raw$latency)
sorted = sorted[1:length(sorted) %% 10==0]
qplot(1:length(sorted),sorted)
