#!/bin/bash
set -e 
export PATH=$PATH:/place/berkanavt/mapreduce/bin
DATE="$1"
REPORTS="$2"
RECIPIENT="$3"

DIR=$(pwd)/$(dirname $0)
cd $DIR/unireports/$DATE

: ${REPORTS:=kpi,uaver,control,timeline,timelineperc,distr,detailed,tech,https}
echo $(date +%T): Running R for $DATE: $REPORTS
/usr/bin/R --vanilla --args $DATE $REPORTS < ../../main.R 2> r.err > r.out
mkdir -p $DIR/kpi/$DATE

tag=$(cat ../../tag)

#echo cp $(pwd)/kpi.*.html $DIR/kpi/$DATE/
cp $(pwd)/kpi.*.html $DIR/kpi/$DATE/
rm -f $DIR/kpi/current
ln -sf $DIR/kpi/$DATE $DIR/kpi/current
rm -f ~/www/unireports${tag}-current
ln -sf $DIR/unireports/$DATE ~/www/unireports${tag}-current

echo "$(date +%T): R - done!"
