
import re
import urllib
import sys

re_split = re.compile(';|,|\/|\(|\)|\.| ')

re_chrome_version=re.compile('Chrome\/[0-9]+')
re_yabrowser_version=re.compile('YaBrowser\/[0-9]+\.[0-9]+')
re_ucbrowser_version=re.compile('UCBrowser\/[0-9]+\.[0-9]+')
re_trident_version=re.compile('rv\:[0-9]+')
re_safari_version=re.compile('Version\/[0-9]+')
re_msie_version=re.compile('MSIE [0-9]+')
re_ff_version=re.compile('Firefox\/[0-9]+')
re_opr_version=re.compile('OPR\/[0-9]+')
re_opera_version=re.compile('Version\/[0-9]+')

def parse_ua(tokens,user_agent):

    if 'Firefox' in tokens or 'PaleMoon' in tokens:
        m = re_ff_version.search(user_agent)
        if m: m=m.group(0)
        return ('Firefox', m)
    elif 'MSIE' in tokens:
        m = re_msie_version.search(user_agent)
        if m:
            m=m.group(0)
            m=m.replace(' ','/')
        return ('MSIE',m)
    elif 'Trident' in tokens:
        m = re_trident_version.search(user_agent)
        if m:
            m=m.group(0)
            m=m.replace('rv:','MSIE/')
        return ('MSIE',m)
    elif 'OPR' in tokens:
        m = re_opr_version.search(user_agent)
        if m:
            m=m.group(0)
            m=m.replace('OPR','Opera')
        return ('Opera',m)
    elif 'Opera' in tokens:
        m = re_opera_version.search(user_agent)
        if m:
            m=m.group(0)
            m=m.replace('Version','Opera')
        return ('Opera',m)
    elif 'YaBrowser' in tokens:
        m = re_yabrowser_version.search(user_agent)
        if m: m=m.group(0)
        return ('YaBrowser',m)
    elif 'Chrome' in tokens:
        m = re_chrome_version.search(user_agent)
        if m: m=m.group(0)
        return ('Chrome',m)
    elif 'UCBrowser' in tokens:
        m = re_ucbrowser_version.search(user_agent)
        if m: m=m.group(0)
        return ('UCBrowser',m)
    elif 'Safari' in tokens:
        m = re_safari_version.search(user_agent)
        if m:
            m=m.group(0)
            m=m.replace('Version','Safari')
        return ('Safari',m)
    else:
        return ("Unknown", None)

def parse_os(tokens):

    if 'iPad' in tokens:
        return 'iPad'
    elif 'iPhone' in tokens:
        return 'iPhone'
    elif 'Android' in tokens:
        return 'Android'
    elif 'Windows' in tokens and 'Phone' in tokens:
        return 'Windows Phone'
    elif 'Windows' in tokens and 'NT' in tokens:
        return 'Windows'
    elif 'Macintosh' in tokens:
        return 'Macintosh'
    elif 'Linux' in tokens:
        return 'Linux'
    #elif 'FreeBSD' in tokens:
    #    return 'FreeBSD'
    else:
        return "Unknown"


def is_turbo(ipaddrs):

    ipaddrs=ipaddrs.split(',')
    if len(ipaddrs)<2:
        return False # no proxy - no turbo

    ipaddr=ipaddrs[0]
    ipaddr = ipaddr.split('.')

    if len(ipaddr)!=4:
        #print >> sys.stderr, "IpV6?: %s" % ipaddrs
        return False #ignore with ipv6 for now

    ipaddr = [int(b) for b in ipaddr]

    #5.45.192.64/26
    #5.45.255.64/26
    #37.140.189.192/26
    #141.8.189.192/27

    if ipaddr >= [5,45,192,64] and ipaddr < [5,45,192,128]:
        return True

    if ipaddr >= [5,45,255,64] and ipaddr < [5,45,255,128]:
        return True

    if ipaddr >= [37,140,189,192] and ipaddr < [37,140,189,256]:
        return True

    if ipaddr >= [141,8,189,192] and ipaddr < [141,8,189,224]:
        return True

    #2a02:6b8:0:c40::/64
    #2a02:6b8:0:1815::/64
    #2a02:6b8:0:1a08::/64
    #2a02:6b8:0:250e::/64

    return False

def update_user_agent(user_agent):

    if user_agent is None:
        return (None,None)

    user_agent = urllib.unquote(user_agent)
    tokens = set(re_split.split(user_agent))

    ua,ver = parse_ua(tokens,user_agent)
    if ver is None:
        ver = ua+"/Unknown"
        #print >> sys.stderr, "Unknown user agent:", ver, user_agent
    os = parse_os(tokens)

    #if ua=="Unknown":
    #    print >> sys.stderr, "unknown User Agent: %s" % user_agent

    #if os=="Unknown":
    #    print >> sys.stderr, "unknown OS: %s" % user_agent

    return (os + "_" + ua + "/" + os, os + "_" + ver)

def get_tld(host_script):

    if 'yandex.com.tr' in host_script:
        tld="com.tr"
    elif 'yandex.com' in host_script:
        tld="com"
    elif 'yandex.ru' in host_script:
        tld="ru"
    elif 'yandex.ua' in host_script:
        tld="ua"
    elif 'yandex.kz' in host_script:
        tld="kz"
    elif 'yandex.by' in host_script:
        tld="by"
    else:
        tld=None

    return tld


def update_one_service(service):

        if "www"==service:
            return "p.www"

        elif "www-touch" == service:
            return "p.www.touch"

        elif "www-smart" == service:
            return "p.www.smart"

        elif "www-tablet" == service:
            return "p.www.tablet"   # TRENCHER-23

        elif "video" == service:
            return "p.video"

        elif "image" == service:
            return "p.images"

        elif "xml" == service:
            return "p.xml"

        elif "api" == service:
            return "p.api"

        elif "gateway" == service:
            return "p.gateway"

        elif ("images.yandex-images.yandex" == service
                or "ru.images.search" == service
                or "tr.images.search" == service
                or "/gorsel/search" in service
                or 'images.search' == service
                or "/images/search" in service):
            return "u.images"

        elif ("video.yandex-video.yandex" == service
                or "ru.video.search" == service
                or "tr.video.search" == service
                or "ua.video.search" == service
                or "by.video.search" == service
                or "kz.video.search" == service
                or 'video.search' == service
                or "/video/pad/search" in service
                or "/video/search" in service):
            return "u.video"

        elif ("ru.images.index" == service
                or "tr.images.index" == service
                or "/gorsel" in service
                or "/images" in service):
            return "u.images.morda"

        elif ("ru.video.index" == service
                or "tr.video.index" == service
                or "/video" in service):
            return "u.video.morda"

        elif ("www.yandex-yandex/touchsearch" == service
                or "ru.web3.search.touch" == service
                or "ru.granny.search.touch" == service
                or "tr.web3.search.touch" == service
                or "com.web3.search.touch" == service
                or "ru.web.search.touch" == service
                or "/touchsearch" in service
                or "/search/touch/" in service):
            return "u.www.touch"

        elif ("www.yandex-yandex/padsearch" == service
                or "ru.web3.search.pad" == service
                or "tr.web3.search.pad" == service
                or "com.web3.search.pad" == service
                or "ru.web.search.pad" == service
                or "/padsearch" in service
                or "/search/pad/" in service):
            return "u.www.tablet"   # TRENCHER-23

        elif ("www.yandex-www.yandex" == service
                or "ru.web3.search" == service
                or "ru.web.search" == service
                or "tr.web3.search" == service
                or "/yandsearch" in service
                or "/search/" in service):
            return "u.www"

        elif ".direct" in service or "direct." in service:
            return None

        elif ".market_test" in service or "market." in service or "market-" in service:
            return None

        elif ".morda.plain" in service:
            return "u.morda.plain"

        elif ".morda.widget" in service:
            return "u.morda.widget"

        elif ".morda.theme" in service:
            return "u.morda.theme"

        elif ".morda.touch" in service:
            return "u.morda.touch"

        #elif 'ru.market_test.index' == service or ('market.yandex' in service and (service[-1]=='/' or '/index.xml' in service) ):
        #    return "market.morda"
        #elif 'ru.market_test.search' == service or ('market.yandex' in service and ('/search.xml' in service or '/offers.xml' in service)):
        #    return "market.search"
        #elif 'ru.market_test.card' == service or ('market.yandex' in service and '/model.xml' in service):
        #    return "market.model"
        #elif 'direct.index' == service or 'direct.yandex.ru/'==service:
        #    return "direct.morda"

        elif '/searchapp' in service:
            return "searchapp"

        elif '.' in service:
            return service

        else:
            print >> sys.stderr, "unknown service: %s" % service
            return service


def update_service(services, insert_unknown=True):

    #make combined searches

    if "u.www.touch" in services and "p.www.touch" in services:
        services |= set(["www.touch"])

    if "u.www.tablet" in services and "p.www.tablet" in services:
        services |= set(["www.tablet"])   # TRENCHER-23

    if "p.www" in services and "u.www" in services:
        services |= set(["www"])

    if "p.video" in services and "u.video" in services:
        services |= set(["video"])

    if "p.images" in services and "u.images" in services:
        services |= set(["images"])

    if "u.morda.plain" in services or ".morda.widget" in services or "u.morda.theme" in services or ".morda.touch" in services:
        services |= set(["u.morda.all"])

    if len(services)==0 and insert_unknown:
        services |= set(["s.unknown"])

    return services

