render_local=function(data_fn_args,gvis) {
  
  if (gvis == FALSE) { return(NULL) }
  
  data=data_fn_args$data
  envir=new.env(parent = baseenv())
  
  for (lr in data_fn_args$fn_args) {
    ll=copy(lr)
    f = ll$f
    ll$f=NULL
    ll$data=data
    ll$gvis=gvis
    #print(ll)
    do.call(f,args=ll,envir=envir)
  }
}

render_snow_helper=function(lr) {  
  ll=copy(lr)
  f = ll$f
  ll$f=NULL
  ll$data=data #global data in this case
  ll$gvis=gvis #global data in this case
  do.call(f,args=ll)
  print("Done") 
  return(TRUE)
}

render_snow=function(data_fn_args,gvis) {
  
  if (gvis == FALSE) { return(NULL) }
  
  data=data_fn_args$data  
  cl=makePSOCKcluster(names=getOption("mc.litecores", 2L),outfile="cluster-debug.txt")
  
  clusterEvalQ(cl,require(bit64))
  clusterEvalQ(cl,library(data.table))
  clusterEvalQ(cl,library(reshape2))
  clusterEvalQ(cl,library(ggplot2))
  clusterEvalQ(cl,library(scales))
  clusterEvalQ(cl,library(knitr))
  clusterEvalQ(cl,library(parallel))
  clusterEvalQ(cl,library(chron))
  clusterEvalQ(cl,source('../../kpi-plot.R'))
  
  clusterExport(cl,"data",environment())
  clusterExport(cl,"gvis",environment())
  clusterExport(cl,"data_list_filter",environment())
  parLapply(cl,data_fn_args$fn_args,render_snow_helper)
  stopCluster(cl)
}

#temporary hack, until I fix parallel processing
render_snow = render_local

render_old_helper = function(ll) { 
  elapsed = do.call(ll$fun,ll[3:length(ll)])
  if (length(elapsed) > 0) {
    elapsed$gvis=as.list(elapsed$gvis)
    elapsed$ggplot=as.list(elapsed$ggplot)
    elapsed$gvis$engine="gvis"
    elapsed$ggplot$engine="ggplot"
    elapsed$gvis$fun=ll$fname
    elapsed$ggplot$fun=ll$fname
    elapsed$gvis$params=paste(ll[3:length(ll)],collapse=" ")
    elapsed$ggplot$params=paste(ll[3:length(ll)],collapse=" ")
    write(paste0(ll$index,"/",total_jobs," ",elapsed$ggplot$output," ",elapsed$ggplot$elapsed),file=stdout())
    write(paste0(ll$index,"/",total_jobs," ",elapsed$gvis$output," ",elapsed$gvis$elapsed),file=stdout())
    return (elapsed)        
  }
}

render_old=function (jobs) {
  total_jobs = length(jobs)
  for (j in 1:length(jobs)) { jobs[[j]]$index=j }
  print(paste("total jobs:",length(jobs))) 
  gc()
  profile=lapply(jobs, render_old_helper) 
  print("Rendering html - done!") 
  
  foo=Filter(Negate(is.null), profile)
  foo=do.call(c,foo)
  foo=do.call(rbind.data.frame,foo)
  write.table(foo, "profile.txt", sep="\t")  
}

render_old_parallel=function (jobs) {
  total_jobs = length(jobs)
  for (j in 1:length(jobs)) { jobs[[j]]$index=j }
  print(paste("total jobs:",length(jobs))) 
  gc()
  parallel_execution_in_fork = TRUE
  profile=mclapply(jobs, render_old_helper, mc.preschedule = FALSE) 
  rm(parallel_execution_in_fork)
  print("Rendering html - done!") 
  
  foo=Filter(Negate(is.null), profile)
  foo=do.call(c,foo)
  foo=do.call(rbind.data.frame,foo)
  write.table(foo, "profile.txt", sep="\t")  
}
