#!/bin/bash
DATE="${1:?Specify date}"
RECIPIENT="${2:?Specify recipient e-mail}"

URL="http://trencher.search.yandex.net/~trencher/kpi-yt/$DATE"

export REPLYTO=web-russia-quality@yandex-team.ru

mail -s "Trencher KPI report for $DATE" \
     -a "MIME-Version: 1.0" \
     -a "Content-type: text/html; charset=utf-8" \
     "$RECIPIENT" \
<<EOF 
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Trencher KPI report</title></head><body>
<p><a href="$URL/kpi.simple.www.gVis.html">Web Desktop</a></p>
<p><a href="$URL/kpi.simple.www.tablet.gVis.html">Web Tablet</a></p>
<p><a href="$URL/kpi.simple.www.touch.gVis.html">Web Touch</a></p>
<p><a href="$URL/kpi.simple.www.touch.p50.gVis.html">Web Touch (p50)</a></p>
<br/>
<p><a href="http://lulzbox.i.fog.yandex.net/wpt-report/web-touch-2g/current.html#Yandex-vs-Google,-2G,-Nexus-5x">WPT: Web Touch 2G report</a></p>
<p><a href="http://lulzbox.i.fog.yandex.net/wpt-report/web-touch-lte/current.html#Yandex-vs-Google,-LTE,-Samsung-J1-(2016)">WPT: Web Touch LTE report</a></p>
</p></body></html>
EOF
