#!/skynet/python/bin/python


import itertools
import subprocess
import threading

import os.path
from os.path import join as pj

from ya_common import ef
import common
import runnerLib # not referenced directly but puts some environment variables

BIN = "/Berkanavt/bin"
SCRIPTS = "/Berkanavt/bin/scripts"

def listCommand(command):
    sub = subprocess.Popen(command, shell=True, stdout=subprocess.PIPE)
    retCode = sub.wait()
    if retCode != 0:
        raise Exception("Command %s has non-zero exit code %d" % (command, retCode))
    return map(lambda line: line.rstrip("\n"), sub.stdout.readlines())

def listServersInt(group):
    sub = subprocess.Popen("%s/yr %s PRINTSERVERLIST" % (SCRIPTS, group), shell=True, close_fds=True, stdout=subprocess.PIPE)
    retData = sub.communicate(); 
    retCode = sub.poll()
    if 0 != retCode:
        raise Exception("yr failed" % (retCode))
    return map(lambda line: line.rstrip("\n"), retData[0].split("\n")[:-1])

def listServers(group):
    return listServersInt("+%s" % group)

def listHTARCs():
    return listServers("HTARC")

def listWSs():
    return listServers("ASEARCH")

def listSDFs():
    return listServers("SDF")

def listSDFMRs():
    return listServers("SDF_MR")

def listFreeze():
    return listServers("FREEZE")


# unused
def listWALRUSes4HTARC(htarc):
    scriptName = "%s/htarclookup" % (SCRIPTS)
    sub = subprocess.Popen("%s -r %s" % (scriptName, htarc), shell=True, stdout=subprocess.PIPE)
    sub.wait()
    return sub.stdout.readline().split(" ")

# unused
def listShardesPhconfig(walrus):
    if not walrus:
        raise Exception("walrus variable should be set")

    scriptName = "%s/phconfig" % (BIN)
    sub = subprocess.Popen("%s H%s r" % (scriptName, walrus), shell=True, stdout=subprocess.PIPE)
    sub.wait()
    line = sub.stdout.read()
    try:
        shardes_count = int(line)
    except ValueError, ve:
        raise Exception("There is no value passed in stdout via phconfig." )

    shardes = list()
    for i in range(shardes_count):
        shardes.append("%.3i" % i)
    return shardes

def listFasttierMainInds(test = False):
    return (['t-fasttier.yandex.ru'] if test else
            list(itertools.chain.from_iterable([ listCommand('sky list +FASTTIER' + str(i))[1:] for i in xrange(1,3) ])))

# unused
def getRerunCommand(command):
    return 'perl -e \\\" \\\\\\$i=0; do  { if (0 != \\\\\\$i) { sleep(30); } ++\\\\\\$i; \\\\\\$res = system(\'' + command + ' \'); } while ( (0 != \\\\\\$res) && (\\\\\\$i < 100) ) \\\" '



class TRobotConfig:
    def __init__(self, name, remoteHost = None):
        self.name = name
        self.remoteHost = remoteHost
        self.configPath = '/Berkanavt/config/conf-' + name
        self.phconfigPath = pj(BIN,'phconfig')
        
        if not remoteHost:
            if not os.path.exists(self.configPath):
                raise Exception('Configuration ' + name + ' not found')
            if not os.path.exists(self.phconfigPath):
                raise Exception('phconfig not found at ' + self.phconfigPath)

        self.cmd = ef('DB_HOME={self.configPath} {self.phconfigPath}')

    def phconfigCmd(self, arg):
        return (ef(r"ssh {self.remoteHost} \"{self.cmd} {arg.replace(r'\\\\',r'\\\\\\\\')}\"") if self.remoteHost 
                else ef('{self.cmd} {arg}'))
                 
    def getSpecialHost(self, name):
        sub = subprocess.Popen(self.phconfigCmd((r" D\\n ") + name), shell=True, stdout=subprocess.PIPE)
        sub.wait()
        return sub.stdout.readlines()[0].strip()

    def listRobotHosts(self):
        sub = subprocess.Popen(self.phconfigCmd(r" D\\n h"), shell=True, stdout=subprocess.PIPE)
        sub.wait()
        return map(lambda x: x.strip(), sub.stdout.readlines())
    
    def listScatterHosts(self):
        sub = subprocess.Popen(self.phconfigCmd(r" D\\n W"), shell=True, stdout=subprocess.PIPE)
        sub.wait()
        return map(lambda x: x.strip(), sub.stdout.readlines())
    
    def listScatterHostsByGroups(self):
        sub = subprocess.Popen(self.phconfigCmd(" G"), shell=True, stdout=subprocess.PIPE)
        sub.wait()
        nGroups = int(sub.stdout.readline().strip())
        groups = []
        for g in xrange(nGroups):
            sub = subprocess.Popen(self.phconfigCmd(r' D\\t g%i M' % g), shell=True, stdout=subprocess.PIPE)
            sub.wait()
            groups.append(sub.stdout.readline().strip().split('\t'))
        
        return groups
    

def runPing(server, port):
    return subprocess.Popen("fetch -o /dev/null -T 5 http://%s:%d/yandsearch?text=test_rare_request" % (server, port), shell=True, stdout=subprocess.PIPE, stdin=subprocess.PIPE, stderr=subprocess.PIPE)

class PingThread(threading.Thread):
    def __init__(self, server, port, failCallback):
        threading.Thread.__init__(self)
        self.mServer = server
        self.mPort = port
        self.mFailCallback = failCallback
        
    def run(self):
        if 0 != runPing(self.mServer, self.mPort).wait():
            self.mFailCallback(self.mServer)
            
def pingServers(servers, port, failCallback):
    threads = []
    for server in servers:
        thread = PingThread(server, port, failCallback)
        thread.start()
        threads.append(thread)
    map(lambda x: x.join(), threads)

def getFail(servers, port):
    failed = []
    pingServers(servers, port, common.ListAppender(failed))
    return failed
