#include "abc_client.h"

namespace NInfra::NClients {

TAbcClient::TAbcClient(NHttpExecuter::THttpExecuterPtr executer)
    : Executer_(executer)
{
}

TConsumerRequest TAbcClient::Consumer() const {
    return TConsumerRequest(Executer_);
}

TConsumerRequest TAbcClient::Consumer(const TString& url) const {
    return TConsumerRequest(Executer_, url);
}

TServiceMembersRequest TAbcClient::ServiceMembers() const {
    return TServiceMembersRequest(Executer_);
}

TServiceMembersRequest TAbcClient::ServiceMembers(const TString& url) const {
    return TServiceMembersRequest(Executer_, url);
}

TUpdateServiceConsumersRequest TAbcClient::UpdateServiceConsumers(i64 id) const {
    return TUpdateServiceConsumersRequest(Executer_, id);
}

TRolesScopesRequest TAbcClient::RolesScopesRequest() const {
    return TRolesScopesRequest(Executer_);
}

TGetAbcServicesRequest TAbcClient::GetAbcServices() const {
    return TGetAbcServicesRequest(Executer_);
}

TGetAbcServicesRequest TAbcClient::GetAbcServices(const TString& url) const {
    return TGetAbcServicesRequest(Executer_, url);
}

} // namespace NInfra::NClients
