#pragma once

#include "abc_request.h"

#include <infra/libs/clients/http_executer/http_executer.h>

namespace NInfra::NClients {

class TAbcClient;
using TAbcClientPtr = TAtomicSharedPtr<TAbcClient>;

class TAbcClient {
public:
    TAbcClient(NHttpExecuter::THttpExecuterPtr executer);

    TConsumerRequest Consumer() const;

    TConsumerRequest Consumer(const TString& url) const;

    TServiceMembersRequest ServiceMembers() const;

    TServiceMembersRequest ServiceMembers(const TString& url) const;

    TUpdateServiceConsumersRequest UpdateServiceConsumers(i64 id) const;

    TRolesScopesRequest RolesScopesRequest() const;

    TGetAbcServicesRequest GetAbcServices() const;

    TGetAbcServicesRequest GetAbcServices(const TString& url) const;

private:
    const NHttpExecuter::THttpExecuterPtr Executer_;
};

} // namespace NInfra::NClients

