#include "abc_executer_mock.h"

namespace NInfra::NClients {

TAbcExecuterMock::TAbcExecuterMock()
    : LogFile_(LOG_FILEPATH, CreateAlways | WrOnly)
{
}

TStringStream TAbcExecuterMock::Execute(
    const TString& path
    , NHttpExecuter::EHttpMethod httpMethod
    , TLogFramePtr /* frame */
    , THeaders&& headers
    , TStringBuf body
    , const TString& /* sensorPathCustomName */
) const {
    TGuard<TMutex> guard(FileMutex_);
    TFileOutput logFileOutput(LogFile_);
    logFileOutput << "Url=" << path << ";";
    logFileOutput << "Method=" << ToString(httpMethod) << ";";
    logFileOutput << "Header={";
    for (auto const& [key, val] : headers) {
        logFileOutput << "{" << key << ";" << val << "};";
    }
    logFileOutput << "};";
    logFileOutput << "Body=" << body << ";\n";
    TStringStream res;
    if (path.Contains("services/members/?")) {
        res << "{\"next\": null, \"previous\": null,  \"count\": 1, \"total_pages\" : 1, \"results\": [{\"person\":{\"login\": \"test\"}, \"id\":228, \"service\":{\"id\":2,\"slug\":\"home\",\"name\":\"name\"}, \"role\": \
{\"scope\": {\"name\": \"null\", \"id\": null}} }]}";
    } else if (path.Contains("resources/consumers/?")) {
        if (path.Contains("id=")) {
            res << "{\"next\": null, \"previous\": null, \"count\": 1, \"total_pages\" : 1, \"results\": [{\"id\": 42, \"resource\":{\"id\": 228}, \"service\" : {\"id\": 1488, \
\"name\": \"name\", \"slug\": \"home\"}, \"state\": \"granted\"}]}";
        } else {
            res << "{\"next\": null, \"previous\": null, \"count\": 1, \"total_pages\" : 1, \"results\": [{\"id\": 37, \"resource\":{\"id\": 228, \
\"attributes\": [{\"name\": \"segment\", \"value\": \"segment_id\"}, {\"name\": \"cpu\", \"value\": \"0.1\"}, {\"name\": \"net\", \"value\": \"30\"}, \
{\"name\": \"memory\", \"value\": \"2.2\"}, {\"name\": \"ip4\", \"value\": \"13\"}, {\"name\": \"io_ssd\", \"value\": \"100.3\"}, {\"name\": \"ssd\", \"value\": \"42.0\"}, \
{\"name\": \"io_hdd\", \"value\": \"70.5\"}, {\"name\": \"hdd\", \"value\": \"14,88\"}, {\"name\": \"gpu_model\", \"value\": \"gpu_tesla_k40\"}, {\"name\": \"gpu_qty\", \"value\": \"5\"}, {\"name\": \"location\", \"value\": \"TEST\"}]}, \
\"service\" : {\"id\": 2, \"name\": \"\", \"slug\": \"home\"}, \"state\": \"granted\"}]}";
        }
    } else if (path.Contains("services/?")) {
        res << "{\"next\": null, \"previous\": null,  \"count\": 1, \"total_pages\" : 1, \"results\": [{\"id\":2,\"slug\":\"home\",\"name\":\"name\"},\
{\"id\":37,\"slug\":\"home\",\"name\":\"enname\"}]}";
    } else {
        res << "{\"results\": []}";
    }
    return res;
}

} // namespace NInfra::NClients
