#include "abc_model.h"

namespace NInfra::NClients {

TServiceMember::TServiceMember(const NJson::TJsonValue& json)
    : Id_(json["id"].GetInteger())
    , PersonLogin_(json["person"]["login"].GetString())
    , ServiceId_(json["service"]["id"].GetInteger())
    , ServiceSlug_(json["service"]["slug"].GetString())
    , ServiceName_(json["service"]["name"])
    , ScopeId_(json["role"]["scope"]["id"].GetInteger())
    , ScopeSlug_(json["role"]["scope"]["slug"].GetString())
    , ScopeName_(json["role"]["scope"]["name"])
{
}

i64 TServiceMember::GetId() const {
    return Id_;
}

TString TServiceMember::GetPersonLogin() const {
    return PersonLogin_;
}

i64 TServiceMember::GetServiceId() const {
    return ServiceId_;
}

TString TServiceMember::GetServiceSlug() const {
    return ServiceSlug_;
}

const NJson::TJsonValue& TServiceMember::GetServiceName() const {
    return ServiceName_;
}

i64 TServiceMember::GetScopeId() const {
    return ScopeId_;
}

TString TServiceMember::GetScopeSlug() const {
    return ScopeSlug_;
}

const NJson::TJsonValue& TServiceMember::GetScopeName() const {
    return ScopeName_;
}

TServiceResource::TServiceResource(const NJson::TJsonValue& json)
    : Id_(json["id"].GetInteger())
    , Resource_(json["resource"])
    , Service_(json["service"])
    , State_(json["state"].GetString())
{
}

i64 TServiceResource::GetId() const {
    return Id_;
}

const NJson::TJsonValue& TServiceResource::GetResource() const {
    return Resource_;
}

const NJson::TJsonValue& TServiceResource::GetService() const {
    return Service_;
}

const TString TServiceResource::GetState() const {
    return State_;
}

TRolesScope::TRolesScope(const NJson::TJsonValue& json)
    : Id_(json["id"].GetInteger())
    , Slug_(json["slug"].GetString())
{
}

i64 TRolesScope::GetId() const {
    return Id_;
}

TString TRolesScope::GetSlug() const {
    return Slug_;
}

TAbcService::TAbcService(const NJson::TJsonValue& json)
    : Id_(json["id"].GetInteger())
    , Slug_(json["slug"].GetString())
    , Name_(json["name"])
{
}

i64 TAbcService::GetId() const {
    return Id_;
}

const TString& TAbcService::GetSlug() const {
    return Slug_;
}

const NJson::TJsonValue& TAbcService::GetName() const {
    return Name_;
}

} // namespace NInfra::NClients
