#pragma once

#include <library/cpp/json/json_reader.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NInfra::NClients {

class TServiceMember {
public:
    TServiceMember(const NJson::TJsonValue& json);

    i64 GetId() const;

    TString GetPersonLogin() const;

    i64 GetServiceId() const;

    TString GetServiceSlug() const;

    const NJson::TJsonValue& GetServiceName() const;

    i64 GetScopeId() const;

    TString GetScopeSlug() const;

    const NJson::TJsonValue& GetScopeName() const;

private:
    const i64 Id_;
    const TString PersonLogin_;
    const i64 ServiceId_;
    const TString ServiceSlug_;
    const NJson::TJsonValue ServiceName_;
    i64 ScopeId_;
    TString ScopeSlug_;
    const NJson::TJsonValue ScopeName_;
};

class TServiceResource {
public:
    TServiceResource(const NJson::TJsonValue& json);

    i64 GetId() const;

    const NJson::TJsonValue& GetResource() const;

    const NJson::TJsonValue& GetService() const;

    const TString GetState() const;

private:
    const i64 Id_;
    const NJson::TJsonValue Resource_;
    const NJson::TJsonValue Service_;
    const TString State_;
};

class TRolesScope {
public:
    TRolesScope(const NJson::TJsonValue& json);

    i64 GetId() const;

    TString GetSlug() const;

private:
    const i64 Id_;
    const TString Slug_;
};

class TAbcService {
public:
    TAbcService(const NJson::TJsonValue& json);

    i64 GetId() const;

    const TString& GetSlug() const;

    const NJson::TJsonValue& GetName() const;

private:
    const i64 Id_;
    const TString Slug_;
    const NJson::TJsonValue Name_;
};

} // namespace NInfra::NClients
