#include "abc_request.h"

namespace NInfra::NClients {

template<typename TResponse>
TAbcRequest<TResponse>::TAbcRequest(NHttpExecuter::THttpExecuterPtr executer, const TString& path, const TCgiParameters& params)
    : Parameters_(params)
    , Executer_(executer)
    , Path_(path)
{
}

TConsumerRequest::TConsumerRequest(NHttpExecuter::THttpExecuterPtr executer, const TString& url)
    : TAbcRequest<TAbcResponse<TServiceResource>>(executer, "/resources/consumers/?", TCgiParameters(TStringBuf(url).After('?')))
{
}

TConsumerRequest&  TConsumerRequest::SetService(i64 id) {
    Parameters_.InsertEscaped("service", ToString(id));
    return *this;
}

TConsumerRequest&  TConsumerRequest::SetResourceTypeId(i64 resourceTypeId) {
    Parameters_.InsertEscaped("type", ToString(resourceTypeId));
    return *this;
}


TServiceMembersRequest::TServiceMembersRequest(NHttpExecuter::THttpExecuterPtr executer, const TString& url)
    : TAbcRequest<TAbcResponse<TServiceMember>>(executer, "/services/members/?", TCgiParameters(TStringBuf(url).After('?')))
{
}

TServiceMembersRequest&  TServiceMembersRequest::SetState(const TString& state) {
    Parameters_.InsertEscaped("state", state);
    return *this;
}

TUpdateServiceConsumersRequest::TUpdateServiceConsumersRequest(NHttpExecuter::THttpExecuterPtr executer, i64 id)
    : TAbcRequest<TAbcResponse<TServiceResource>>(executer, "/resources/consumers/?")
{
    Parameters_.InsertEscaped("id", ToString(id));
}

TUpdateServiceConsumersRequest&  TUpdateServiceConsumersRequest::SetState(const TString& state) {
    Parameters_.InsertEscaped("state", state);
    return *this;
}

TRolesScopesRequest::TRolesScopesRequest(NHttpExecuter::THttpExecuterPtr executer)
    : TAbcRequest<TAbcResponse<TRolesScope>>(executer, "/roles/scopes/")
{
}

TGetAbcServicesRequest::TGetAbcServicesRequest(NHttpExecuter::THttpExecuterPtr executer, const TString& url)
    : TAbcRequest<TAbcResponse<TAbcService>>(executer, "/services/?", TCgiParameters(TStringBuf(url).After('?')))
{
}

} // namespace NInfra::NClients
