#include "abc_request.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NClients {

namespace {

NHttpExecuter::THttpExecuterPtr GetTestExecuter() {
    return MakeAtomicShared<NHttpExecuter::THttpExecuter>(NHttpExecuter::THttpExecuterConfig());
}

} // namespace

Y_UNIT_TEST_SUITE(AbcRequestTest) {
    Y_UNIT_TEST(ConsumerRequestSetAndExecuteTest) {
        TConsumerRequest P(GetTestExecuter());
        P.SetResourceTypeId(1)
         .SetFields({"state", "id"})
         .SetPage(42)
         .SetPageSize(100);
        UNIT_ASSERT_STRINGS_EQUAL(P.GetPathWithParams(), "/resources/consumers/?fields=state%2Cid&page=42&page_size=100&type=1");
    }

    Y_UNIT_TEST(ServiceMembersRequestSetAndExecuteTest) {
        TServiceMembersRequest P(GetTestExecuter());
        P.SetState("approved")
         .SetFields({"state", "person.login"})
         .SetPage(42)
         .SetPageSize(100);
        UNIT_ASSERT_STRINGS_EQUAL(P.GetPathWithParams(), "/services/members/?fields=state%2Cperson.login&page=42&page_size=100&state=approved");
    }

    Y_UNIT_TEST(UpdateServiceConsumersRequestSetAndExecuteTest) {
        TUpdateServiceConsumersRequest P(GetTestExecuter(), 228);
        P.SetState("granted")
         .SetFields({"state", "person.login"})
         .SetPage(42)
         .SetPageSize(100);
        UNIT_ASSERT_STRINGS_EQUAL(P.GetPathWithParams(), "/resources/consumers/?fields=state%2Cperson.login&id=228&page=42&page_size=100&state=granted");
    }
};

} // namespace NInfra::NClients
