#pragma once

#include <library/cpp/json/json_reader.h>

namespace NInfra::NClients {

template<typename TResult>
class TAbcResponse {
public:
    TAbcResponse(const NJson::TJsonValue& json)
        : NextPageUrl_(json["next"].GetString())
        , PrevPageUrl_(json["previous"].GetString())
        , Count_(json["count"].GetInteger())
        , TotalPages_(json["total_pages"].GetInteger())
        , Results_(json["results"].GetArray().begin(), json["results"].GetArray().end())
    {
    }

    TString GetNextPageUrl() const {
        return NextPageUrl_;
    }

    TString GetPrevPageUrl() const {
        return PrevPageUrl_;
    }

    i32 GetCount() const {
        return Count_;
    }

    i32 GetTotalPages() const {
        return TotalPages_;
    }

    const TVector<TResult>& GetResults() const {
        return Results_;
    }

private:
    const TString NextPageUrl_;
    const TString PrevPageUrl_;
    const i32 Count_;
    const i32 TotalPages_;

    const TVector<TResult> Results_;
};

} // namespace NInfra::NClients
