#pragma once

#include <infra/libs/clients/http_executer/http_executer.h>

namespace NInfra::NClients {

enum class EGolovanPeriod : int {
    FIVE_SEC = 5
    , FIVE_MIN = 300
    , ONE_HOUR = 3600
    , THREE_HOURS = 10800
    , SIX_HOURS = 21600
    , TWELVE_HOURS = 43200
    , ONE_DAY = 86400
};

class TGolovanSingleStatRequest {
public:
    TGolovanSingleStatRequest(NHttpExecuter::THttpExecuterPtr executer);

    TGolovanSingleStatRequest& SetTag(const TString& key, const TString& value);

    TGolovanSingleStatRequest& SetSignal(const TString& signal);

    TGolovanSingleStatRequest& SetPeriod(EGolovanPeriod period);

    TGolovanSingleStatRequest& SetHost(const TString& host);

    double Execute(TLogFramePtr frame) const;

private:
    TString GetPathWithParams() const;

    TString GetSignals() const;

    TString GetBody() const;

private:
    THashMap<TString, TString> Labels_;
    TString Signal_;
    EGolovanPeriod Period_;
    TString Host_;

    NHttpExecuter::THttpExecuterPtr Executer_;
};

} // namespace NInfra::NClients
