#pragma once

#include <infra/libs/clients/http_executer/http_executer.h>

namespace NInfra::NHttpExecuter {

class THttpExecuterMock : public NHttpExecuter::IHttpExecuter {
public:
    THttpExecuterMock(TStringStream response)
        : Response_(response)
    {}

    virtual TStringStream Execute(
        const TString& path
        , NHttpExecuter::EHttpMethod httpMethod
        , TLogFramePtr frame
        , THeaders&& headers = {}
        , TStringBuf body = {}
        , const TString& sensorPathCustomName = ""
    ) const override final;

private:
    TStringStream Response_;
};

} // namespace NInfra::NHttpExecuter
