#include "nanny_request.h"

#include <library/cpp/json/json_reader.h>

#include <util/string/builder.h>

namespace NInfra::NClients {

TGetServiceResourcesRequest::TGetServiceResourcesRequest(NHttpExecuter::THttpExecuterPtr executer)
    : Executer_(executer) {
}

TGetServiceResourcesRequest& TGetServiceResourcesRequest::SetServiceId(const TString& serviceId) {
    ServiceId_ = serviceId;
    return *this;
}

THashMap<TString, TString> TGetServiceResourcesRequest::Execute(TLogFramePtr frame) const {
    TStringStream output = Executer_->Execute(
        TStringBuilder() << "/services/" << ServiceId_ << "/runtime_attrs/resources/"
        , NHttpExecuter::EHttpMethod::GET
        , frame
    );
    auto jsonResponse = NJson::ReadJsonTree(&output, true);

    THashMap<TString, TString> res;
    for (const auto& staticFile : jsonResponse["content"]["static_files"].GetArray()) {
        res.emplace(staticFile["local_path"].GetString(), staticFile["content"].GetString());
    }
    return res;
}

} // namespace NInfra::NClients
