#pragma once

#include "racktables_model.h"

#include <infra/libs/clients/racktables/config/config.pb.h>

#include <infra/libs/clients/http_executer/http_executer.h>

#include <library/cpp/json/json_value.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/system/file.h>
#include <util/system/mutex.h>

namespace NInfra::NRackTables {

class IRackTablesClient;
using TRackTablesClientPtr = TAtomicSharedPtr<IRackTablesClient>;

class IRackTablesClient {
public:
    virtual THashMap<TString, TString> GetIP4ToFqdnMap(TLogFramePtr frame) const = 0;

    virtual void RemoveIP4(const TString& ip, TLogFramePtr frame) = 0;

    virtual void UpdateIP4Fqdn(const TString& ip4, const TString& fqdn, TLogFramePtr frame) = 0;

    virtual TVector<TNetworkProject> LoadVmIds(TLogFramePtr frame) const = 0;

    virtual THashMap<TString, const TVector<i64>> LoadMacroProjectsIds(TLogFramePtr frame) const = 0;

    virtual TVector<TMacroOwners> LoadMacroOwners(TLogFramePtr frame) const = 0;

    virtual TVector<TFirewallSection> LoadFirewallSections(TLogFramePtr frame) const = 0;

    virtual TVector<TIP4AddressPoolPtr> LoadIP4AddressPools(TLogFramePtr frame) const = 0;

    virtual ~IRackTablesClient() = default;
};

class TRackTablesClientMock : public IRackTablesClient {
    virtual THashMap<TString, TString> GetIP4ToFqdnMap(TLogFramePtr frame) const override final;

    virtual void RemoveIP4(const TString& ip4, TLogFramePtr frame) override final;

    virtual void UpdateIP4Fqdn(const TString& ip4, const TString& fqdn, TLogFramePtr frame) override final;

    virtual TVector<TNetworkProject> LoadVmIds(TLogFramePtr frame) const override final;

    virtual THashMap<TString, const TVector<i64>> LoadMacroProjectsIds(TLogFramePtr frame) const override final;

    virtual TVector<TMacroOwners> LoadMacroOwners(TLogFramePtr frame) const override final;

    virtual TVector<TFirewallSection> LoadFirewallSections(TLogFramePtr frame) const override final;

    virtual TVector<TIP4AddressPoolPtr> LoadIP4AddressPools(TLogFramePtr frame) const override final;
};

class TRackTablesClient : public IRackTablesClient {
public:
    TRackTablesClient(const TRackTablesClientConfig& config, NHttpExecuter::THttpExecuterPtr executer);

    virtual THashMap<TString, TString> GetIP4ToFqdnMap(TLogFramePtr frame) const override final;

    virtual void RemoveIP4(const TString& ip4, TLogFramePtr frame) override final;

    virtual void UpdateIP4Fqdn(const TString& ip4, const TString& fqdn, TLogFramePtr frame) override final;

    virtual TVector<TNetworkProject> LoadVmIds(TLogFramePtr frame) const override final;

    virtual THashMap<TString, const TVector<i64>> LoadMacroProjectsIds(TLogFramePtr frame) const override final;

    virtual TVector<TMacroOwners> LoadMacroOwners(TLogFramePtr frame) const override final;

    virtual TVector<TFirewallSection> LoadFirewallSections(TLogFramePtr frame) const override final;

    virtual TVector<TIP4AddressPoolPtr> LoadIP4AddressPools(TLogFramePtr frame) const override final;

private:
    using TJsonMapType = NJson::TJsonValue::TMapType;

    const TRackTablesClientConfig::TRackTablesPathConfig ApiPaths_;
    const NHttpExecuter::THttpExecuterPtr Executer_;
};

class TRackTablesClientLocal : public IRackTablesClient {
public:
    TRackTablesClientLocal();

    virtual THashMap<TString, TString> GetIP4ToFqdnMap(TLogFramePtr frame) const override final;

    virtual void RemoveIP4(const TString& ip4, TLogFramePtr frame) override final;

    virtual void UpdateIP4Fqdn(const TString& ip4, const TString& fqdn, TLogFramePtr frame) override final;

    virtual TVector<TNetworkProject> LoadVmIds(TLogFramePtr frame) const override final;

    virtual THashMap<TString, const TVector<i64>> LoadMacroProjectsIds(TLogFramePtr frame) const override final;

    virtual TVector<TMacroOwners> LoadMacroOwners(TLogFramePtr frame) const override final;

    virtual TVector<TFirewallSection> LoadFirewallSections(TLogFramePtr frame) const override final;

    virtual TVector<TIP4AddressPoolPtr> LoadIP4AddressPools(TLogFramePtr frame) const override final;

private:
    const TFile LogFile_;
    TMutex LogMutex_;
    THashMap<TString, TString> RackTablesState_;

    static const TString LOG_FILEPATH;
};

} // namespace NInfra::NRackTables
