#pragma once

#include <infra/libs/clients/http_executer/http_executer.h>

namespace NInfra::NClients {

class TSolomonSingleStatRequest {
public:
    TSolomonSingleStatRequest(NHttpExecuter::THttpExecuterPtr executer);

    TSolomonSingleStatRequest& SetProject(const TString& project);

    TSolomonSingleStatRequest& SetService(const TString& service);

    TSolomonSingleStatRequest& SetCluster(const TString& cluster);

    TSolomonSingleStatRequest& SetHost(const TString& host);

    TSolomonSingleStatRequest& SetSensor(const TString& sensor);

    TSolomonSingleStatRequest& SetPath(const TString& path);

    TSolomonSingleStatRequest& SetPeriod(const TDuration& period);

    TSolomonSingleStatRequest& SetAggregationType(const TString& aggregationType);

    TSolomonSingleStatRequest& AddAdvancedAttribute(const TString& key, const TString& value);

    double Execute(TLogFramePtr frame) const;

private:
    TString GetPathWithParams() const;

    TString GetProgram() const;

    TString GetBody() const;

private:
    TString Project_;
    TString Service_;
    TString Cluster_;
    TString Host_;
    TMaybe<TString> Sensor_;
    TMaybe<TString> Path_;
    TString AggregationType_;

    TDuration Period_;

    THashMap<TString, TString> AdvancedAttributes_;

    NHttpExecuter::THttpExecuterPtr Executer_;
};

} // namespace NInfra::NClients
