#include "staff_executer_mock.h"

namespace NInfra::NClients {

TStaffExecuterMock::TStaffExecuterMock()
    : LogFile_(LOG_FILEPATH, CreateAlways | WrOnly)
{
}

TStringStream TStaffExecuterMock::Execute(
    const TString& path
    , NHttpExecuter::EHttpMethod httpMethod
    , TLogFramePtr /* frame */
    , THeaders&& headers
    , TStringBuf body
    , const TString& /* sensorPathCustomName */
) const {
    TGuard<TMutex> guard(FileMutex_);
    TFileOutput logFileOutput(LogFile_);
    logFileOutput << "Url=" << path << ";";
    logFileOutput << "Method=" << ToString(httpMethod) << ";";
    logFileOutput << "Header={";
    for (auto const& [key, val] : headers) {
        logFileOutput << "{" << key << ";" << val << "};";
    }
    logFileOutput << "};";
    logFileOutput << "Body=" << body << ";\n";
    TString res;
    if (path.Contains("/persons?")) {
        if (!path.Contains("id+%3E")) {
            res = "{\"limit\": 1, \"result\": [{\"login\": \"test\", \"name\":{\"first\":{\"ru\":\"имя\"}}, \"keys\":\"\"}], \"page\": 1}";
        } else {
            res = "{\"limit\": 1, \"result\": [], \"page\": 1}";
        }
    } else if (path.Contains("/groups?")) {
        if (!path.Contains("id+%3E")) {
            res = "{\"limit\": 1, \"result\": [{\"id\": 228, \"department\": {\"id\": 42, \"name\": {\"full\": \"\"}}}],  \"page\": 1}";
        } else {
            res = "{\"limit\": 1, \"result\": [], \"page\": 1}";
        }
    } else if (path.Contains("/groupmembership?")) {
        if (!path.Contains("id+%3E")) {
            res = "{\"limit\": 1, \"result\": [{\"person\" : {\"login\": \"test\"}, \"group\": {\"id\": 228, \"department\": {\"id\": 42, \"name\": {\"full\": \"\"}}}}], \"page\": 1}";
        } else {
            res = "{\"limit\": 1, \"result\": [], \"page\": 1}";
        }
    } else {
        ythrow yexception() << "Invalid url path";
    }
    return res;
}

} // namespace NInfra::NClients
