#pragma once

#include <infra/libs/clients/http_executer/http_executer.h>

#include <util/stream/file.h>
#include <util/system/mutex.h>

namespace NInfra::NClients {

class TStaffExecuterMock : public NHttpExecuter::IHttpExecuter {
public:
    TStaffExecuterMock();

    virtual TStringStream Execute(
        const TString& path
        , NHttpExecuter::EHttpMethod httpMethod
        , TLogFramePtr frame
        , THeaders&& headers = {}
        , TStringBuf body = {}
        , const TString& sensorPathCustomName = ""
    ) const override final;

private:
    const TFile LogFile_;

    TMutex FileMutex_;

    static inline const TString LOG_FILEPATH = "staff.log";
};

} // namespace NInfra::NClients
