#include "staff_model.h"

namespace NInfra::NClients {

TGroup::TGroup(const NJson::TJsonValue& json)
    : Id_(json["id"].GetInteger())
    , Type_(json["type"].GetString())
    , Deleted_(json["is_deleted"].GetBoolean())
    , DepartmentUrl_(json["department"]["url"].GetString())
    , DepartmentName_(json["department"]["name"]["full"])
{
    if (!json["department"]["id"].IsNull()) {
        DepartmentId_ = json["department"]["id"].GetInteger();
    }
    if (!json["parent"].IsNull() && !json["parent"]["department"].IsNull()) {
        ParentDepartmentId_ = json["parent"]["department"]["id"].GetInteger();
    }
    for (const NJson::TJsonValue& jsonHead : json["department"]["heads"].GetArray()) {
        DepartmentHead_.push_back(TPerson(jsonHead["person"]));
    }

    if (!json["service"].IsNull() && !json["service"]["id"].IsNull()) {
        ServiceId_ = json["service"]["id"].GetInteger();
    }
    if (!json["parent"].IsNull() && !json["parent"]["service"].IsNull()) {
        ParentServiceId_ = json["parent"]["service"]["id"].GetInteger();
    }
    if (!json["role_scope"].IsNull()) {
        RoleScope_ = json["role_scope"].GetString();
    }
}

i32 TGroup::GetId() const {
    return Id_;
}

const TString& TGroup::GetType() const {
    return Type_;
}

bool TGroup::GetDeleted() const {
    return Deleted_;
}

TMaybe<i32> TGroup::GetDepartmentId() const {
    return DepartmentId_;
}

TMaybe<i32> TGroup::GetParentDepartmentId() const {
    return ParentDepartmentId_;
}

const TVector<TPerson>& TGroup::GetDepartmentHead() const {
    return DepartmentHead_;
}

const TString& TGroup::GetDepartmentUrl() const {
    return DepartmentUrl_;
}

const NJson::TJsonValue& TGroup::GetDepartmentName() const {
    return DepartmentName_;
}

TMaybe<i32> TGroup::GetServiceId() const {
    return ServiceId_;
}

TMaybe<i32> TGroup::GetParentServiceId() const {
    return ParentServiceId_;
}

TMaybe<TString> TGroup::GetRoleScope() const {
    return RoleScope_;
}

TPerson::TPerson(const NJson::TJsonValue& json)
    : Id_(json["id"].GetInteger())
    , Login_(json["login"].GetString())
    , Uid_(json["uid"].GetString())
    , Deleted_(json["is_deleted"].GetBoolean())
    , Dismissed_(json["official"]["is_dismissed"].GetBoolean())
    , Type_(json["official"]["is_robot"].GetBoolean() ? "robot" : "person")
    , Name_(json["name"])
    , Keys_(json["keys"])
{
    for (auto const& jsonGroup : json["groups"].GetArray()) {
        Groups_.emplace_back(TGroup(jsonGroup));
    }
}


i32 TPerson::GetId() const {
    return Id_;
}

const TString& TPerson::GetUid() const {
    return Uid_;
}

const TString& TPerson::GetLogin() const {
    return Login_;
}

const TVector<TGroup>& TPerson::GetGroups() const {
    return Groups_;
}

bool TPerson::GetDeleted() const {
    return Deleted_;
}

bool TPerson::GetDismissed() const {
    return Dismissed_;
}

const TString& TPerson::GetType() const {
    return Type_;
}

const NJson::TJsonValue& TPerson::GetName() const {
    return Name_;
}

const NJson::TJsonValue& TPerson::GetKeys() const {
    return Keys_;
}

TGroupMembership::TGroupMembership(const NJson::TJsonValue& json)
    : Person_(json["person"])
    , Group_(json["group"])
    , Id_(json["id"].GetInteger())
{
}

const TPerson& TGroupMembership::GetPerson() const {
    return Person_;
}

const TGroup& TGroupMembership::GetGroup() const {
    return Group_;
}

i32 TGroupMembership::GetId() const {
    return Id_;
}

} // namespace NInfra::NClients
