#pragma once

#include <library/cpp/json/json_reader.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NInfra::NClients {

class TPerson;

class TGroup {
public:
    TGroup(const NJson::TJsonValue& json);

    i32 GetId() const;

    const TString& GetType() const;

    bool GetDeleted() const;

    TMaybe<i32> GetDepartmentId() const;

    TMaybe<i32> GetParentDepartmentId() const;

    const TVector<TPerson>& GetDepartmentHead() const;

    const TString& GetDepartmentUrl() const;

    const NJson::TJsonValue& GetDepartmentName() const;

    TMaybe<i32> GetServiceId() const;

    TMaybe<i32> GetParentServiceId() const;

    TMaybe<TString> GetRoleScope() const;

private:
    const i32 Id_;
    const TString Type_;
    const bool Deleted_;

    const TString DepartmentUrl_;
    const NJson::TJsonValue DepartmentName_;
    TMaybe<i32> DepartmentId_;
    TMaybe<i32> ParentDepartmentId_;
    TVector<TPerson> DepartmentHead_;

    TMaybe<i32> ServiceId_;
    TMaybe<i32> ParentServiceId_;
    TMaybe<TString> RoleScope_;
};

class TPerson {
public:
    TPerson(const NJson::TJsonValue& json);

    i32 GetId() const;

    const TString& GetLogin() const;

    const TString& GetUid() const;

    const TVector<TGroup>& GetGroups() const;

    bool GetDeleted() const;

    bool GetDismissed() const;

    const TString& GetType() const;

    const NJson::TJsonValue& GetName() const;

    const NJson::TJsonValue& GetKeys() const;

private:
    const i32 Id_;
    const TString Login_;
    const TString Uid_;
    const bool Deleted_;
    const bool Dismissed_;
    const TString Type_;
    NJson::TJsonValue Name_;
    TVector<TGroup> Groups_;
    NJson::TJsonValue Keys_;
};

class TGroupMembership {
public:
    TGroupMembership(const NJson::TJsonValue& json);

    const TPerson& GetPerson() const;

    const TGroup& GetGroup() const;

    i32 GetId() const;

private:
    const TPerson Person_;
    const TGroup Group_;
    const i32 Id_;
};

} // namespace NInfra::NClients
