#include "staff_request.h"

namespace NInfra::NClients {

template<typename TResponse>
TStaffRequest<TResponse>::TStaffRequest(NHttpExecuter::THttpExecuterPtr executer, const TString& path)
    : Executer_(executer)
    , Path_(path)
{
}

TPersonRequest::TPersonRequest(NHttpExecuter::THttpExecuterPtr executer)
    : TStaffRequest<TStaffResponse<TPerson>>(executer, "/persons?")
{
}


TGroupsRequest::TGroupsRequest(NHttpExecuter::THttpExecuterPtr executer)
    : TStaffRequest<TStaffResponse<TGroup>>(executer, "/groups?")
{
}

TGroupMembershipRequest::TGroupMembershipRequest(NHttpExecuter::THttpExecuterPtr executer)
    : TStaffRequest<TStaffResponse<TGroupMembership>>(executer, "/groupmembership?")
{
}

TGroupsRequest& TGroupsRequest::SetType(TString&& groupType) {
    Parameters_.InsertEscaped(TStringBuf("type"),  groupType);
    return *this;
}

} // namespace NInfra::NClients
