#pragma once

#include "staff_response.h"
#include "staff_model.h"

#include <infra/libs/clients/http_executer/http_executer.h>

#include <library/cpp/cgiparam/cgiparam.h>

#include <util/string/join.h>

namespace NInfra::NClients {

template<typename TResponse>
class TStaffRequest {
public:
    TStaffRequest(NHttpExecuter::THttpExecuterPtr executer, const TString& path);

    TStaffRequest<TResponse>& SetPage(i32 page) {
        Parameters_.InsertEscaped(TStringBuf("_page"), ToString(page));
        return *this;
    }

    TStaffRequest<TResponse>& SetSort(TString&& sortField) {
        Parameters_.InsertEscaped(TStringBuf("_sort"), sortField);
        return *this;
    }

    TStaffRequest<TResponse>& SetLimit(i32 limit) {
        Parameters_.InsertEscaped(TStringBuf("_limit"),  ToString(limit));
        return *this;
    }

    TStaffRequest<TResponse>& SetFields(TVector<TString>&& fields) {
        Parameters_.InsertEscaped(TStringBuf("_fields"), JoinSeq(",", fields));
        return *this;
    }

    TStaffRequest<TResponse>& SetQuery(TVector<std::pair<TString, TString>>&& query) {
        for (auto const& [key, val] : query) {
            Parameters_.InsertEscaped(TStringBuf(key), val);
        }
        return *this;
    }

    TResponse Execute(TLogFramePtr frame) const {
        TStringStream output = Executer_->Execute(GetPathWithParams(), NHttpExecuter::EHttpMethod::GET, frame);
        return TResponse(NJson::ReadJsonTree(&output, true));
    }

    TString GetPathWithParams() const {
        return Path_ + Parameters_.Print();
    }

protected:
    TCgiParameters Parameters_;

private:
    const NHttpExecuter::THttpExecuterPtr Executer_;
    const TString Path_;
};

class TPersonRequest : public TStaffRequest<TStaffResponse<TPerson>>{
public:
    TPersonRequest(NHttpExecuter::THttpExecuterPtr executer);
};

class TGroupsRequest : public TStaffRequest<TStaffResponse<TGroup>>{
public:
    TGroupsRequest(NHttpExecuter::THttpExecuterPtr executer);

    TGroupsRequest& SetType(TString&& groupType);
};

class TGroupMembershipRequest : public TStaffRequest<TStaffResponse<TGroupMembership>> {
public:
    TGroupMembershipRequest(NHttpExecuter::THttpExecuterPtr executer);
};

} // namespace NInfra::NClients
