#include "staff_request.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NClients {

namespace {

NHttpExecuter::THttpExecuterPtr GetTestExecuter() {
    return MakeAtomicShared<NHttpExecuter::THttpExecuter>(NHttpExecuter::THttpExecuterConfig());
}

} // namespace

Y_UNIT_TEST_SUITE(StaffRequestTest) {
    Y_UNIT_TEST(PersonRequestSetAndExecuteTest) {
        TPersonRequest P(GetTestExecuter());
        P.SetPage(14)
         .SetFields({"id", "login", "is_deleted"})
         .SetSort("id")
         .SetLimit(100);
        UNIT_ASSERT_STRINGS_EQUAL(P.GetPathWithParams(), "/persons?_fields=id%2Clogin%2Cis_deleted&_limit=100&_page=14&_sort=id");
    }

    Y_UNIT_TEST(GroupsRequestSetAndExecuteTest) {
        TGroupsRequest P(GetTestExecuter());
        P.SetType("department")
         .SetPage(14)
         .SetFields({"id", "type", "department.id","is_deleted"})
         .SetSort("department.id")
         .SetLimit(100);
        UNIT_ASSERT_STRINGS_EQUAL(P.GetPathWithParams(), "/groups?_fields=id%2Ctype%2Cdepartment.id%2Cis_deleted&_limit=100&_page=14&_sort=department.id&type=department");
    }

    Y_UNIT_TEST(GroupMembershipRequestSetAndExecuteTest) {
        TGroupMembershipRequest P(GetTestExecuter());
        P.SetPage(14)
         .SetFields({"person.login", "group.department.id"})
         .SetQuery({{"group.type", "department"}, {"person.is_deleted", "false"}})
         .SetSort("id")
         .SetLimit(100);
        UNIT_ASSERT_STRINGS_EQUAL(P.GetPathWithParams(), "/groupmembership?_fields=person.login%2Cgroup.department.id&_limit=100&_page=14&_sort=id&group.type=department&person.is_deleted=false");
    }
};

} // namespace NInfra::NClients
