#pragma once

#include <library/cpp/json/json_reader.h>
#include <util/generic/hash.h>

namespace NInfra::NClients {

using TPairString = std::pair<TString, TString>;

template<typename TResult>
class TStaffResponse {
public:
    TStaffResponse(const NJson::TJsonValue& json)
        : Page_(json["page"].GetInteger())
        , Pages_(json["pages"].GetInteger())
        , Limit_(json["limit"].GetInteger())
        , Total_(json["total"].GetInteger())
    {
        for (auto const& [key, jsonLink] : json["links"].GetMap()) {
            Links_.emplace_back(TPairString(key, jsonLink.GetString()));
        }

        for (auto const& jsonResult : json["result"].GetArray()) {
            Results_.emplace_back(TResult(jsonResult));
        }
    }

    i32 GetPage() const {
        return Page_;
    }

    i32 GetLimit() const {
        return Limit_;
    }

    i32 GetTotal() const {
        return Total_;
    }

    i32 GetPages() const {
        return Pages_;
    }

    const TVector<TPairString>& GetLinks() const {
        return Links_;
    }

    const TVector<TResult>& GetResults() const {
        return Results_;
    }

private:
    const i32 Page_;
    const i32 Pages_;
    const i32 Limit_;
    const i32 Total_;

    TVector<TPairString> Links_;
    TVector<TResult> Results_;
};

} // namespace NInfra::NClients
