#include "yav_request.h"

#include <library/cpp/json/json_reader.h>

#include <util/string/builder.h>

namespace NInfra::NClients {

TGetSecretVersionRequest::TGetSecretVersionRequest(NHttpExecuter::THttpExecuterPtr executer)
    : Executer_(executer) {
}

TGetSecretVersionRequest& TGetSecretVersionRequest::SetVersionUuid(const TString& versionUuid) {
    VersionUuid_ = versionUuid;
    return *this;
}

THashMap<TString, TString> TGetSecretVersionRequest::Execute(TLogFramePtr frame) const {
    TStringStream output = Executer_->Execute(
        TStringBuilder{} << "/versions/" << VersionUuid_
        , NHttpExecuter::EHttpMethod::GET
        , frame
    );
    auto jsonResponse = NJson::ReadJsonTree(&output, true);

    THashMap<TString, TString> secretKeyToValue;
    for (const auto& secret : jsonResponse["version"]["value"].GetArray()) {
        secretKeyToValue.emplace(secret["key"].GetString(), secret["value"].GetString());
    }
    return secretKeyToValue;
}

} // namespace NInfra::NClients
