#pragma once

#include <infra/libs/controller/object_manager/object_manager.h>

#include <yp/cpp/yp/client.h>

#include <yt/yt/orm/library/filter_matcher.h>

using namespace NInfra::NController;

struct TCachedFilterMatcher {
    NYT::NOrm::NLibrary::IFilterMatcherPtr Matcher;
    TVector<size_t> AttributeIndices;

    TCachedFilterMatcher() 
        : Matcher(NYT::NOrm::NLibrary::CreateConstantFilterMatcher(true))
        , AttributeIndices({})
    {
    }

    TCachedFilterMatcher(
        NYT::NOrm::NLibrary::IFilterMatcherPtr matcher
        , TVector<size_t> attributeIndices
    )
        : Matcher(std::move(matcher))
        , AttributeIndices(std::move(attributeIndices))
    {
    }
};

TStringBuf GetClusterNameByClient(
    const IObjectManager::TSelectArgument& selectArgument,
    NYP::NClient::TClientPtr client
);

void ValidateFilter(const TString& filter, const TSet<TString>& whitelist);

TVector<TString> ExtractClientFilterSelectorsFromArgument(
    const IObjectManager::TSelectArgument& selectArg
    , const TStringBuf cluster
);

TVector<TString> ExtractAllSelectors(
    const IObjectManager::TSelectArgument& selectArgument
    , const TStringBuf cluster
);

TVector<size_t> GetIndependentAttributesIndices(const TVector<TString>& selectors);

TCachedFilterMatcher CreateFilterMatcher(
    const IObjectManager::TSelectArgument& selectArgument,
    const TMaybe<TString>& extractedFilter,
    NYP::NClient::TClientPtr client
);

void ApplyFilterOnSelectResult(
    TSelectObjectsResult& objectsSelectResults
    , const IObjectManager::TSelectArgument& selectArgument
    , const TCachedFilterMatcher& matcher
);

TVector<TString> ExtractKeyFieldValue(const IObjectManager::TSelectArgument& selectArgument, const TStringBuf clusterName);
