#pragma once

#include <infra/libs/controller/controller/controller_loop.h>
#include <infra/libs/controller/service_iface/service.h>

#include <infra/libs/http_service/service.h>

namespace NInfra::NController {

class TService: public IService {
public:
    TService(const THttpServiceConfig& cfg, TLogger& logger, NController::TControllerLoop& controller);

    void Start(TLogFramePtr logFrame);

    void Wait(TLogFramePtr logFrame);

    void Ping(TRequestPtr<TReqPing>, TReplyPtr<TRspPing> reply) override;

    void Leader(TRequestPtr<TReqLeader>, TReplyPtr<TRspLeader> reply) override;

    void Shutdown(TRequestPtr<TReqShutdown>, TReplyPtr<TRspShutdown> reply) override;

    void Sensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors> reply) override;

    void ReopenLog(TRequestPtr<TReqReopenLog>, TReplyPtr<TRspReopenLog>) override;

protected:
    TService(const THttpServiceConfig& cfg, TLogger& logger, NController::TControllerLoop& controller, TRequestRouterPtr router);

    TLogger& Logger_;
    NController::TControllerLoop& Controller_;

private:
    THolder<THttpService> HttpService_;
};

} // namespace NInfra::NController
