#include "service.h"

#include <infra/libs/service_iface/str_iface.h>

namespace NInfra::NController {

TRequestRouterPtr CreateRouter(IService& service) {
    auto router = MakeSimpleShared<TRequestRouter<IService>>(service);

    (*router)
        .Add<TEmptyRequest<TReqLeader>, TProto2JsonReply<TRspLeader, false, NProtobufJson::TProto2JsonConfig::EnumName>>("/leader", "Current leader.", &IService::Leader)
        .Add<TEmptyRequest<TReqPing>, TRawDataReply<TRspPing>>("/ping", "Pong.", &IService::Ping)
        .Add<TEmptyRequest<TReqReopenLog>, TEmptyReply<TRspReopenLog>>("/reopen_log", "Reopen eventlog.", &IService::ReopenLog)
        .Add<TEmptyRequest<TReqSensors>, TRawDataReply<TRspSensors>>("/sensors", "Show controller sensors.", &IService::Sensors)
        .Add<TEmptyRequest<TReqShutdown>, TEmptyReply<TRspShutdown>>("/shutdown", "Shutdown controller.", &IService::Shutdown);

    return router;
}

} // namespace NInfra::NController
