#pragma once

#include <infra/libs/controller/service_iface/protos/service.pb.h>

#include <infra/libs/service_iface/errors.h>
#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>
#include <infra/libs/service_iface/router.h>

namespace NInfra::NController {

class IService {
public:
    virtual void Leader(TRequestPtr<TReqLeader>, TReplyPtr<TRspLeader>) {
        ythrow TNotImplementedError();
    }

    virtual void Ping(TRequestPtr<TReqPing>, TReplyPtr<TRspPing>) {
        ythrow TNotImplementedError();
    }

    virtual void ReopenLog(TRequestPtr<TReqReopenLog>, TReplyPtr<TRspReopenLog>) {
        ythrow TNotImplementedError();
    }

    virtual void Sensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors>) {
        ythrow TNotImplementedError();
    }

    virtual void Shutdown(TRequestPtr<TReqShutdown>, TReplyPtr<TRspShutdown>) {
        ythrow TNotImplementedError();
    }

    virtual ~IService() = default;
};

TRequestRouterPtr CreateRouter(IService& service);

} // namespace NInfra::NController
