#include <infra/libs/controller/shard_master/config/config.pb.h>
#include <infra/libs/controller/shard_master/sensors/sensors.h>
#include <infra/libs/controller/shard_master/service/service.h>

#include <infra/libs/sensors/macros.h>
#include <infra/libs/sensors/sensor.h>

#include <library/cpp/proto_config/load.h>

namespace NInfra::NController::NShardMaster {

template<typename THttpService = TService, typename... TServiceArgs>
int RunDaemon(
    NUpdatableProtoConfig::TAccessor<TConfig> config,
    TVector<TDistributionManagerPtr> distributionManagers,
    TServiceArgs&&... serviceArgs
) {
    static_assert(std::is_convertible<THttpService*, NController::IService*>::value);
    auto onLogWriteError = [] {
        STATIC_INFRA_RATE_SENSOR(NSensors::LOGGER_SENSOR_GROUP, NSensors::WRITE_FAILED);
        Cout.Flush();
        Cerr << CurrentExceptionMessage() << Endl;
    };

    const auto configSnapshot = config.Get();
    TLogger logger(configSnapshot->GetLogger(), onLogWriteError);

    {
        THashSet<TString> distributionManagersNames;
        for (const auto& distributionManager : distributionManagers) {
            Y_ENSURE(distributionManagersNames.insert(distributionManager->GetName()).second, "Service names must be unique");
        }
    }

    TMasterLoop loop(std::move(config), logger, distributionManagers);

    THttpService httpService(configSnapshot->GetHttpService(), logger, loop, std::forward<TServiceArgs>(serviceArgs)...);
    httpService.Start(logger.SpawnFrame());

    loop.RunLoop();
    httpService.Wait(logger.SpawnFrame());

    return EXIT_SUCCESS;
}

} // namespace NInfra::NController::NShardMaster
