#pragma once

#include <infra/libs/sensors/sensor_group.h>

#include <util/generic/strbuf.h>

namespace NInfra::NController::NShardMaster::NSensors {

// Sensor groups
static const TSensorGroup CTL_SHARD_MASTER_SENSOR_GROUP = TStringBuf("controller_shard_master");
static const TSensorGroup LOGGER_SENSOR_GROUP = TStringBuf("logger");

// Labels
constexpr TStringBuf SERVICE_NAME = "service_name";

// Sensors
constexpr TStringBuf LOCK_ACQUIRED = "lock_acquired";
constexpr TStringBuf MANAGE_SHARDS_DISTRIBUTION_TIME = "manage_shards_distribution_time";
constexpr TStringBuf RESHARDING_CYCLES = "resharding_cycles";
constexpr TStringBuf SUCCESSFUL_RESHARDING_CYCLES = "successful_resharding_cycles";

// Error sensors
constexpr TStringBuf FAILED_RESHARDING_CYCLES = "failed_resharding_cycles";
constexpr TStringBuf SHARD_WITHOUT_AVAILABLE_HOSTS = "shard_without_available_hosts";
constexpr TStringBuf WRITE_FAILED = "write_failed";

} // namespace NInfra::NController::NShardMaster::NSensors
