#pragma once

#include <infra/libs/controller/shard_master/shard_master/master_loop.h>
#include <infra/libs/controller/service_iface/service.h>

#include <infra/libs/http_service/service.h>

namespace NInfra::NController::NShardMaster {

class TService: public IService {
public:
    TService(const THttpServiceConfig& cfg, TLogger& logger, TMasterLoop& masterLoop);

    void Start(TLogFramePtr logFrame);

    void Wait(TLogFramePtr logFrame);

    void Ping(TRequestPtr<TReqPing>, TReplyPtr<TRspPing> reply) override;

    void Leader(TRequestPtr<TReqLeader>, TReplyPtr<TRspLeader> reply) override;

    void Shutdown(TRequestPtr<TReqShutdown>, TReplyPtr<TRspShutdown> reply) override;

    void Sensors(TRequestPtr<TReqSensors>, TReplyPtr<TRspSensors> reply) override;

    void ReopenLog(TRequestPtr<TReqReopenLog>, TReplyPtr<TRspReopenLog>) override;

protected:
    TService(const THttpServiceConfig& cfg, TLogger& logger, TMasterLoop& masterLoop, TRequestRouterPtr router);

    TLogger& Logger_;
    TMasterLoop& MasterLoop_;

private:
    THolder<THttpService> HttpService_;
};

} // namespace NInfra::NController::NShardMaster

