#pragma once

#include "distribution_manager.h"

namespace NInfra::NController::NShardMaster {

using TGetActualConfig = std::function<std::pair<const TConfig&, bool>()>;

class TMasterLoop {
public:
    TMasterLoop(
        NUpdatableProtoConfig::TAccessor<TConfig> config,
        TLogger& logger,
        TVector<TDistributionManagerPtr> distributionManagers
    );

    void RunLoop();

    void Shutdown();

    void ReopenLogs();

    NLeadingInvader::TLeaderInfo GetLeaderInfo(TMaybe<TString> leadingInvaderName = Nothing()) const;

private:
    void RunManageShardsDistribution(
        TDistributionManagerPtr distributionManager
        , const TConfig& actualConfig
    );

    void DistributionManagerLoop(
        TDistributionManagerPtr distributionManager
        , TGetActualConfig getActualConfig
    );

    static void* RunDistributionManagerLoop(
        void* data
    );

private:
    NUpdatableProtoConfig::TAccessor<TConfig> Config_;
    TAtomic Running_;
    TLogger& Logger_;
    TVector<TDistributionManagerPtr> DistributionManagers_;
};

} // namespace NInfra::NController::NShardMaster
