#pragma once

#include <infra/libs/leading_invader/leading_invader.h>
#include <infra/libs/logger/logger.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/vector.h>
#include <util/system/rwlock.h>

namespace NInfra::NController {


// TODO(ismagilas): Tests for TShardMasterDistributionSubscriber
class TShardMasterDistributionSubscriber {
public:
    static TString BuildLivenessNodePath(const TString& prefix, size_t shardId);

    static TString BuildGivenJobNodePath(const TString& prefix, size_t shardId);

public:
    TShardMasterDistributionSubscriber(
        bool managedByMaster
        , size_t shardId
        , const TString& ensureMasterLivenessTime
        , const TString& masterLeadingInvaderPath
        , const NLeadingInvader::TConfig& livenessLeadingInvaderConfig);

    bool RegisterLiveness(
        TLogFramePtr frame
        , const std::function<void()>& onLockAcquired = []{}
        , const std::function<void()>& onLockLost = []{}
    );

    bool EnsureTaskPermissionByMaster(TLogFramePtr frame);

    bool EnsureShardMasterIsAlive(TLogFramePtr frame);

private:
    bool ManagedByMaster_;
    const size_t ShardId_;

    NLeadingInvader::TConfig LivenessLeadingInvaderConfig_;
    NLeadingInvader::TLeadingInvaderHolder LivenessLeadingInvader_;

    const TString YtFolderPrefix_;
    const TString EnsureMasterLivenessTime_;
    const TString MasterLeadingInvaderPath_;
    const TString GivenJobNodePath_;
    NYT::IClientPtr YtClient_;
};

using TShardMasterDistributionSubscriberPtr = TAtomicSharedPtr<TShardMasterDistributionSubscriber>;

class TShard {
public:
    TShard(
        size_t numberOfShards
        , size_t id
        , bool managedByMaster
        , const TString& ensureMasterLivenessTime
        , const TString& masterLeadingInvaderPath
        , const NLeadingInvader::TConfig& leadingInvaderConfig
        , const NLeadingInvader::TConfig& livenessLeadingInvaderConfig);

    size_t GetNumberOfShards() const;

    size_t GetShardId() const;

    bool IsManagedByMaster() const;

    TShardMasterDistributionSubscriberPtr GetShardMasterDistributionSubscriber() const;

    NLeadingInvader::TConfig GetLeadingInvaderConfig() const;

    TString GetFullLeadingInvaderName() const;

    TString BuildFullName(const TString& name) const;

    TExpected<void, NLeadingInvader::TError> EnsureLeading();

    NLeadingInvader::TLeaderInfo GetLeaderInfo() const;

    void ResetLeadingInvader(
        const std::function<void()>& onLockAcquired = []{}
        , const std::function<void()>& onLockLost = []{}
        , bool ignoreIfSet = false
    );

    void DestroyLeadingInvader();
private:
    size_t NumberOfShards_;
    size_t Id_;
    bool ManagedByMaster_;
    const TString EnsureMasterLivenessTime_;
    const TString MasterLeadingInvaderPath_;

    NLeadingInvader::TConfig LeadingInvaderConfig_;
    NLeadingInvader::TLeadingInvaderHolder LeadingInvader_;
    TRWMutex LeadingInvaderMutex_;

    TShardMasterDistributionSubscriberPtr ShardMasterDistributionSubscriber_;
};

using TShardPtr = TAtomicSharedPtr<TShard>;

class TSharding {
public:
    TSharding();

    TSharding(
        const NLeadingInvader::TConfig& leadingInvaderConfig
        , const NLeadingInvader::TConfig& livenessLeadingInvaderConfig = {}
        , size_t numberOfShards = 1
        , bool managedByMaster = false
        , const TString& ensureMasterLivenessTime = "30s"
        , const TString& masterLeadingInvaderPath = "");

    TShardPtr GetShard(size_t id);

    size_t GetNumberOfShards() const;

    NLeadingInvader::TConfig GetLeadingInvaderConfig() const;

    NLeadingInvader::TConfig GetLivenessLeadingInvaderConfig() const;

private:
    size_t NumberOfShards_;
    bool ManagedByMaster_;
    const TString EnsureMasterLivenessTime_;
    const TString MasterLeadingInvaderPath_;
    NLeadingInvader::TConfig LeadingInvaderConfig_;
    NLeadingInvader::TConfig LivenessLeadingInvaderConfig_;
    TVector<TShardPtr> Shards_;
};

} // namespace NInfra::NController
