#pragma once

#include <infra/libs/controller/config/config.pb.h>
#include <infra/libs/controller/controller/controller.h>
#include <infra/libs/controller/object_manager/object_manager.h>

#include <yp/cpp/yp/client.h>

#include <infra/libs/leading_invader/leading_invader.h>
#include <infra/libs/logger/logger.h>
#include <infra/libs/updatable_proto_config/holder.h>

#include <library/cpp/proto_config/config.h>

#include <util/system/thread.h>

namespace NInfra::NController {

class TStandaloneController {
public:
    TStandaloneController(NInfra::NController::TControllerConfig config, TObjectManagersFactoryPtr objectFactory);

    TStandaloneController(NInfra::NController::TControllerConfig config, TVector<TObjectManagersFactoryPtr> objectFactories);

    TStandaloneController(NInfra::NController::TControllerConfig config, TVector<TSingleClusterObjectManagersFactoryPtr> objectFactories);

    TStandaloneController(NInfra::NController::TControllerConfig config, TVector<TSingleClusterObjectManagerFactoryPtr> objectFactories);

    TStandaloneController(TStringBuf config, TObjectManagersFactoryPtr objectFactory);

    void Sync();

    bool SafeSync();

protected:
    TLogger Logger_;

private:
    const NInfra::NController::TControllerConfig Config_;
    TVector<TObjectManagersFactoryPtr> ObjectFactories_;
    TVector<TControllerPtr> Controllers_;
    const ui32 RetryCount_;
    const ui32 ThreadPoolSize_;
    const ui32 AuxThreadPoolSize_;
    TThreadPool MtpQueue_;
    THolder<IThreadPool> AuxMtpQueue_;
    const ui32 YpRequestsBatchSize_;
    const ui32 MaxSeqFailedObjMngrsCount_;
    const TDuration DefaultSyncInterval_;
    const TDuration WatchObjectsTimeLimit_;
    const TSet<TString> WatchObjectsBannedObjectsTypes_;
    const TSet<TString> ForceAlwaysSelectObjectsForTypes_;
};

template<class TController, class TConfig>
class TStandaloneControllerWrapper {
public:
    TStandaloneControllerWrapper(const TStringBuf config)
        : InitialConfig_(NProtoConfig::ParseConfigFromJson<TConfig>(config))
    {
        const NController::TControllerConfig controllerConfig(InitialConfig_.GetController());

        if (controllerConfig.GetUpdatableConfigOptions().GetEnabled()) {
            Config_ = NUpdatableProtoConfig::CreateConfigHolder(
                InitialConfig_,
                controllerConfig.GetUpdatableConfigOptions().GetWatchPatchConfig(),
                controllerConfig.GetUpdatableConfigOptions().GetConfigUpdatesLoggerConfig()
            );
        } else {
            Config_ = NUpdatableProtoConfig::CreateConfigHolder<NUpdatableProtoConfig::TStaticConfigHolder>(InitialConfig_);
        }

        Controller_ = MakeHolder<TController>(Config_->Accessor());
    }

    void Sync() {
        return Controller_->Sync();
    }

    bool SafeSync() {
        return Controller_->SafeSync();
    }

private:
    const TConfig InitialConfig_;
    NUpdatableProtoConfig::TConfigHolderPtr<TConfig> Config_;
    THolder<TController> Controller_;
};

} // namespace NInfra::NController
